/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.support.finder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;
import org.jboss.security.xacml.sunxacml.support.finder.PolicyCollection;
import org.jboss.security.xacml.sunxacml.support.finder.PolicyReader;
import org.jboss.security.xacml.sunxacml.support.finder.TopLevelPolicyException;

public class FilePolicyModule
extends PolicyFinderModule {
    private File schemaFile = null;
    private Set fileNames = new HashSet();
    private PolicyCollection policies = new PolicyCollection();
    private static final Logger logger = Logger.getLogger(FilePolicyModule.class.getName());

    public FilePolicyModule() {
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public FilePolicyModule(File schemaFile) {
        this.schemaFile = schemaFile;
    }

    public FilePolicyModule(String schemaFile) {
        this(schemaFile != null ? new File(schemaFile) : null);
    }

    public FilePolicyModule(List fileNames) {
        this();
        if (fileNames != null) {
            this.fileNames.addAll(fileNames);
        }
    }

    public FilePolicyModule(List fileNames, String schemaFile) {
        this(schemaFile);
        if (fileNames != null) {
            this.fileNames.addAll(fileNames);
        }
    }

    public boolean addPolicy(String filename) {
        return this.fileNames.add(filename);
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        PolicyReader reader = new PolicyReader(finder, logger, this.schemaFile);
        for (String fname : this.fileNames) {
            try {
                AbstractPolicy policy = reader.readPolicy(new FileInputStream(fname));
                this.policies.addPolicy(policy);
            }
            catch (FileNotFoundException fnfe) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "File couldn't be read: " + fname, fnfe);
            }
            catch (ParsingException pe) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Error reading policy from file " + fname, pe);
            }
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        try {
            AbstractPolicy policy = this.policies.getPolicy(context);
            if (policy == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (TopLevelPolicyException tlpe) {
            return new PolicyFinderResult(tlpe.getStatus());
        }
    }
}

