/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.cache.impl.SimpleCacheImpl;
import org.infinispan.cache.impl.StatsCollectingCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.BinaryEncoder;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.CompatModeEncoder;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.GlobalMarshallerEncoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.eviction.impl.ActivationManagerStub;
import org.infinispan.eviction.impl.PassivationManagerStub;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.impl.ClusterEventManagerStub;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerStub;
import org.infinispan.stats.impl.StatsCollector;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.xsite.XSiteAdminOperations;

public class InternalCacheFactory<K, V>
extends AbstractNamedCacheComponentFactory {
    public Cache<K, V> createCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws CacheConfigurationException {
        try {
            if (configuration.simpleCache()) {
                return this.createSimpleCache(configuration, globalComponentRegistry, cacheName);
            }
            return this.createAndWire(configuration, globalComponentRegistry, cacheName);
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<? extends Encoder> getEncoderClass(GlobalConfiguration globalConfiguration, Configuration configuration) {
        boolean compatEnabled = configuration.compatibility().enabled();
        boolean embeddedMode = Configurations.isEmbeddedMode(globalConfiguration);
        if (compatEnabled && !embeddedMode) {
            return CompatModeEncoder.class;
        }
        StorageType storageType = configuration.memory().storageType();
        if (storageType == StorageType.BINARY) {
            return BinaryEncoder.class;
        }
        if (embeddedMode && storageType == StorageType.OFF_HEAP) {
            return GlobalMarshallerEncoder.class;
        }
        return IdentityEncoder.class;
    }

    protected AdvancedCache<K, V> createAndWire(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws Exception {
        Class<Encoder> encoderClass = this.getEncoderClass(globalComponentRegistry.getGlobalConfiguration(), configuration);
        DataConversion keyDataConversion = new DataConversion(encoderClass, ByteArrayWrapper.class);
        DataConversion valueDataConversion = new DataConversion(encoderClass, ByteArrayWrapper.class);
        StreamingMarshaller marshaller = globalComponentRegistry.getOrCreateComponent(StreamingMarshaller.class);
        AdvancedCache cache = new CacheImpl(cacheName);
        cache = new EncoderCache(cache, keyDataConversion, valueDataConversion);
        this.bootstrap(cacheName, cache, configuration, globalComponentRegistry, marshaller);
        if (marshaller != null) {
            this.componentRegistry.wireDependencies(marshaller);
        }
        return cache;
    }

    private AdvancedCache<K, V> createSimpleCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) {
        Class<Encoder> encoderClass = this.getEncoderClass(globalComponentRegistry.getGlobalConfiguration(), configuration);
        JMXStatisticsConfiguration jmxStatistics = configuration.jmxStatistics();
        final boolean statisticsAvailable = jmxStatistics != null && jmxStatistics.available();
        DataConversion keyDataConversion = new DataConversion(encoderClass, ByteArrayWrapper.class);
        DataConversion valueDataConversion = new DataConversion(encoderClass, ByteArrayWrapper.class);
        AdvancedCache cache = statisticsAvailable ? new StatsCollectingCache(cacheName, keyDataConversion, valueDataConversion) : new SimpleCacheImpl(cacheName, keyDataConversion, valueDataConversion);
        this.configuration = configuration;
        cache = new EncoderCache(cache, keyDataConversion, valueDataConversion);
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader()){

            @Override
            protected void bootstrapComponents() {
                if (statisticsAvailable) {
                    this.registerComponent((Object)new StatsCollector.Factory(), StatsCollector.Factory.class);
                }
                this.registerComponent(new ClusterEventManagerStub(), ClusterEventManager.class);
                this.registerComponent((Object)new PassivationManagerStub(), PassivationManager.class);
                this.registerComponent((Object)new ActivationManagerStub(), ActivationManager.class);
                this.registerComponent((Object)new PersistenceManagerStub(), PersistenceManager.class);
            }

            @Override
            public void cacheComponents() {
                this.getOrCreateComponent(ExpirationManager.class);
            }
        };
        this.componentRegistry.registerComponent(new CacheJmxRegistration(), CacheJmxRegistration.class.getName(), true);
        this.componentRegistry.registerComponent(new RollingUpgradeManager(), RollingUpgradeManager.class.getName(), true);
        this.componentRegistry.registerComponent(cache, Cache.class.getName(), true);
        return cache;
    }

    private void bootstrap(String cacheName, AdvancedCache<?, ?> cache, Configuration configuration, GlobalComponentRegistry globalComponentRegistry, StreamingMarshaller marshaller) {
        this.configuration = configuration;
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader());
        this.componentRegistry.registerComponent(cache, Cache.class.getName(), true);
        this.componentRegistry.registerComponent(new CacheJmxRegistration(), CacheJmxRegistration.class.getName(), true);
        if (configuration.transaction().recovery().enabled()) {
            this.componentRegistry.registerComponent(new RecoveryAdminOperations(), RecoveryAdminOperations.class.getName(), true);
        }
        if (configuration.sites().hasEnabledBackups()) {
            this.componentRegistry.registerComponent(new XSiteAdminOperations(), XSiteAdminOperations.class.getName(), true);
        }
        this.componentRegistry.registerComponent(new RollingUpgradeManager(), RollingUpgradeManager.class.getName(), true);
    }

    @Override
    public <T> T construct(Class<T> componentType) {
        throw new UnsupportedOperationException("Should never be invoked - this is a bootstrap factory.");
    }
}

