/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.result.NullResultHandler;
import org.aesh.command.impl.validator.NullCommandValidator;
import org.aesh.command.map.MapCommand;
import org.aesh.command.map.MapCommandPopulator;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.populator.CommandPopulator;
import org.aesh.command.result.ResultHandler;
import org.aesh.command.validator.CommandValidator;
import org.aesh.util.ReflectionUtil;

public class MapProcessedCommandBuilder {
    private static final ProcessedOptionProvider EMPTY_PROVIDER = new ProcessedOptionProvider(){

        @Override
        public List<ProcessedOption> getOptions(List<ProcessedOption> options) {
            return Collections.emptyList();
        }
    };
    private ProcessedOptionProvider provider;
    private String name;
    private String description;
    private CommandValidator<?> validator;
    private ResultHandler resultHandler;
    private ProcessedOption arguments;
    private ProcessedOption argument;
    private final List<ProcessedOption> options = new ArrayList<ProcessedOption>();
    private CommandPopulator populator;
    private MapCommand command;
    private List<String> aliases;
    private CommandActivator activator;

    public MapProcessedCommandBuilder name(String name) {
        this.name = name;
        return this;
    }

    public MapProcessedCommandBuilder name(List<String> aliases) {
        this.aliases = aliases == null ? Collections.emptyList() : Collections.unmodifiableList(aliases);
        return this;
    }

    public MapProcessedCommandBuilder description(String usage) {
        this.description = usage;
        return this;
    }

    public MapProcessedCommandBuilder optionProvider(ProcessedOptionProvider provider) {
        this.provider = provider;
        return this;
    }

    public MapProcessedCommandBuilder arguments(ProcessedOption arguments) {
        this.arguments = arguments;
        return this;
    }

    public MapProcessedCommandBuilder argument(ProcessedOption argument) {
        this.argument = argument;
        return this;
    }

    public MapProcessedCommandBuilder validator(CommandValidator<?> validator) {
        this.validator = validator;
        return this;
    }

    public MapProcessedCommandBuilder validator(Class<? extends CommandValidator> validator) {
        this.validator = this.initValidator(validator);
        return this;
    }

    private CommandValidator initValidator(Class<? extends CommandValidator> validator) {
        if (validator != null && !validator.equals(NullCommandValidator.class)) {
            return ReflectionUtil.newInstance(validator);
        }
        return new NullCommandValidator();
    }

    public MapProcessedCommandBuilder resultHandler(Class<? extends ResultHandler> resultHandler) {
        this.resultHandler = this.initResultHandler(resultHandler);
        return this;
    }

    private ResultHandler initResultHandler(Class<? extends ResultHandler> resultHandler) {
        if (resultHandler != null && !resultHandler.equals(NullResultHandler.class)) {
            return ReflectionUtil.newInstance(resultHandler);
        }
        return new NullResultHandler();
    }

    public MapProcessedCommandBuilder resultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        return this;
    }

    public MapProcessedCommandBuilder populator(CommandPopulator populator) {
        this.populator = populator;
        return this;
    }

    public MapProcessedCommandBuilder command(MapCommand command) {
        this.command = command;
        return this;
    }

    public MapProcessedCommandBuilder command(Class<? extends MapCommand> command) {
        this.command = ReflectionUtil.newInstance(command);
        return this;
    }

    public MapProcessedCommandBuilder addOption(ProcessedOption option) {
        this.options.add(option);
        return this;
    }

    public MapProcessedCommandBuilder addOptions(List<ProcessedOption> options) {
        if (options != null) {
            this.options.addAll(options);
        }
        return this;
    }

    public MapProcessedCommandBuilder activator(CommandActivator activator) {
        this.activator = activator;
        return this;
    }

    public ProcessedCommand create() throws CommandLineParserException {
        if (this.name == null || this.name.length() < 1) {
            throw new CommandLineParserException("The parameter name must be defined");
        }
        if (this.validator == null) {
            this.validator = new NullCommandValidator();
        }
        if (this.resultHandler == null) {
            this.resultHandler = new NullResultHandler();
        }
        if (this.populator == null) {
            this.populator = new MapCommandPopulator(this.command);
        }
        return new MapProcessedCommand(this.name, this.aliases, this.command, this.description, this.validator, this.resultHandler, this.arguments, this.options, this.argument, this.populator, this.provider, this.activator);
    }

    public static interface ProcessedOptionProvider {
        public List<ProcessedOption> getOptions(List<ProcessedOption> var1);
    }

    private static class MapProcessedCommand
    extends ProcessedCommand<MapCommand> {
        private final ProcessedOptionProvider provider;
        private List<ProcessedOption> currentOptions;

        MapProcessedCommand(String name, List<String> aliases, MapCommand command, String description, CommandValidator validator, ResultHandler resultHandler, ProcessedOption arguments, List<ProcessedOption> options, ProcessedOption argument, CommandPopulator populator, ProcessedOptionProvider provider, CommandActivator activator) throws OptionParserException {
            super(name, aliases, command, description, validator, resultHandler, arguments, options, argument, populator, activator);
            this.provider = provider == null ? EMPTY_PROVIDER : provider;
        }

        @Override
        public List<ProcessedOption> getOptions() {
            ArrayList<ProcessedOption> allOptions = new ArrayList<ProcessedOption>(super.getOptions());
            if (this.provider != null) {
                this.currentOptions = this.provider.getOptions(this.currentOptions);
                allOptions.addAll(this.currentOptions);
            }
            return allOptions;
        }
    }
}

