/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh;

import java.io.IOException;
import org.aesh.command.Command;
import org.aesh.command.CommandRuntime;
import org.aesh.command.invocation.CommandInvocationBuilder;
import org.aesh.command.invocation.CommandInvocationConfiguration;
import org.aesh.command.shell.Shell;
import org.aesh.readline.Prompt;
import org.aesh.readline.terminal.Key;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Size;
import org.aesh.util.Parser;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.impl.CommandContextImpl;
import org.jboss.as.cli.impl.ReadlineConsole;
import org.jboss.as.cli.impl.aesh.CLICommandInvocationImpl;
import org.jboss.as.cli.impl.aesh.CLICommandRegistry;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

public class CLICommandInvocationBuilder
implements CommandInvocationBuilder<Command<CLICommandInvocation>, CLICommandInvocation> {
    private final ReadlineConsole console;
    private final CommandContextImpl ctx;
    private final CLICommandRegistry registry;
    private final Shell shell;

    CLICommandInvocationBuilder(CommandContextImpl ctx, CLICommandRegistry registry, ReadlineConsole console) {
        this.ctx = ctx;
        this.registry = registry;
        this.console = console;
        this.shell = new ShellImpl(console, ctx);
    }

    @Override
    public CLICommandInvocation build(CommandRuntime<Command<CLICommandInvocation>, CLICommandInvocation> runtime, CommandInvocationConfiguration configuration) {
        return new CLICommandInvocationImpl(this.ctx.newTimeoutCommandContext(), this.registry, this.console, this.shell, runtime, configuration);
    }

    public class ShellImpl
    implements Shell {
        private final ReadlineConsole console;
        private final CommandContextImpl ctx;

        public ShellImpl(ReadlineConsole console, CommandContextImpl ctx) {
            this.console = console;
            this.ctx = ctx;
        }

        @Override
        public void write(String out, boolean paging) {
            this.ctx.print(out, false, paging);
        }

        @Override
        public void write(char out) {
            this.ctx.print("" + out, false, false);
        }

        @Override
        public void writeln(String out, boolean paging) {
            this.ctx.print(out, true, paging);
        }

        @Override
        public void write(int[] out) {
            this.ctx.print(Parser.stripAwayAnsiCodes(Parser.fromCodePoints(out)), false, false);
        }

        @Override
        public String readLine() throws InterruptedException {
            try {
                return this.ctx.input("", false);
            }
            catch (IOException | CommandLineException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public String readLine(Prompt prompt) throws InterruptedException {
            try {
                return this.ctx.input(prompt);
            }
            catch (IOException | CommandLineException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Key read() throws InterruptedException {
            try {
                return Key.findStartKey(this.ctx.input());
            }
            catch (IOException | CommandLineException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Key read(Prompt prompt) throws InterruptedException {
            return null;
        }

        @Override
        public boolean enableAlternateBuffer() {
            return this.console == null ? false : this.console.getConnection().put(Capability.enter_ca_mode, new Object[0]);
        }

        @Override
        public boolean enableMainBuffer() {
            return this.console == null ? false : this.console.getConnection().put(Capability.exit_ca_mode, new Object[0]);
        }

        @Override
        public Size size() {
            return this.console == null ? new Size(80, 40) : this.console.getConnection().size();
        }

        @Override
        public void clear() {
            if (this.console != null) {
                this.console.clearScreen();
            }
        }
    }
}

