/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.push;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.UIWebsocket;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

public class WebsocketFacesListener
implements SystemEventListener {
    private static final String SCRIPT_OPEN = "jsf.push.open('%s');";
    private static final String SCRIPT_CLOSE = "jsf.push.close('%s');";

    public static void subscribeIfNecessary(FacesContext context) {
        UIViewRoot view = context.getViewRoot();
        List listeners = view.getListenersForEventClass(PostAddToViewEvent.class);
        if (listeners == null || !listeners.stream().anyMatch(l -> l instanceof WebsocketFacesListener)) {
            view.subscribeToViewEvent(PreRenderViewEvent.class, (SystemEventListener)new WebsocketFacesListener());
        }
    }

    public static boolean isNew(FacesContext context, UIWebsocket websocket) {
        return WebsocketFacesListener.getInitializedWebsockets(context).putIfAbsent(websocket.getClientId(context), websocket.isConnected()) == null;
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (!(event instanceof PreRenderViewEvent)) {
            return;
        }
        FacesContext context = ((ComponentSystemEvent)event).getFacesContext();
        for (Map.Entry<String, Boolean> initializedWebsocket : WebsocketFacesListener.getInitializedWebsockets(context).entrySet()) {
            String clientId = initializedWebsocket.getKey();
            UIWebsocket websocket = (UIWebsocket)context.getViewRoot().findComponent(clientId);
            boolean connected = websocket.isRendered() && websocket.isConnected();
            boolean previouslyConnected = initializedWebsocket.setValue(connected);
            if (previouslyConnected == connected) continue;
            String script = String.format(connected ? SCRIPT_OPEN : SCRIPT_CLOSE, clientId);
            PartialViewContext pvc = context.getPartialViewContext();
            if (pvc.isAjaxRequest() && !pvc.isRenderAll()) {
                context.getPartialViewContext().getEvalScripts().add(script);
                continue;
            }
            UIOutput outputScript = new UIOutput();
            outputScript.setRendererType("javax.faces.resource.Script");
            UIOutput content = new UIOutput();
            content.setValue((Object)script);
            outputScript.getChildren().add(content);
            context.getViewRoot().addComponentResource(context, (UIComponent)outputScript, "body");
        }
    }

    private static Map<String, Boolean> getInitializedWebsockets(FacesContext context) {
        Map viewScope = context.getViewRoot().getViewMap();
        HashMap initializedWebsockets = (HashMap)viewScope.get(WebsocketFacesListener.class.getName());
        if (initializedWebsockets == null) {
            initializedWebsockets = new HashMap();
            viewScope.put(WebsocketFacesListener.class.getName(), initializedWebsockets);
        }
        return initializedWebsockets;
    }
}

