/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.infinispan;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.infinispan.AdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.jpa.hibernate4.HibernateSecondLevelCache;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.cache.spi.Wrapper;
import org.jipijapa.event.impl.internal.Notification;

public class InfinispanRegionFactory
extends org.hibernate.cache.infinispan.InfinispanRegionFactory {
    private static final long serialVersionUID = 6526170943015350422L;
    public static final String CACHE_CONTAINER = "hibernate.cache.infinispan.container";
    public static final String DEFAULT_CACHE_CONTAINER = "hibernate";
    public static final String CACHE_PRIVATE = "private";
    private volatile Wrapper wrapper;

    public InfinispanRegionFactory() {
    }

    public InfinispanRegionFactory(Properties props) {
        super(props);
    }

    protected EmbeddedCacheManager createCacheManager(Properties properties) throws CacheException {
        String name = properties.getProperty("hibernate.session_factory_name");
        String container = properties.getProperty(CACHE_CONTAINER, DEFAULT_CACHE_CONTAINER);
        HibernateSecondLevelCache.addSecondLevelCacheDependencies(properties, null);
        Properties cacheSettings = new Properties();
        cacheSettings.setProperty("cachetype", CACHE_PRIVATE);
        cacheSettings.setProperty("container", container);
        if (name != null) {
            cacheSettings.setProperty("name", name);
        }
        cacheSettings.setProperty("caches", String.join((CharSequence)" ", HibernateSecondLevelCache.findCaches(properties)));
        try {
            this.wrapper = Notification.startCache((Classification)Classification.INFINISPAN, (Properties)cacheSettings);
            return (EmbeddedCacheManager)this.wrapper.getValue();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    protected void stopCacheManager() {
        Notification.stopCache((Classification)Classification.INFINISPAN, (Wrapper)this.wrapper);
    }

    protected AdvancedCache createCacheWrapper(AdvancedCache cache) {
        return cache;
    }
}

