/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.aggregated;

import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ElementKind;
import javax.validation.metadata.GroupConversionDescriptor;
import org.hibernate.validator.HibernateValidatorPermission;
import org.hibernate.validator.internal.engine.valuehandling.UnwrapMode;
import org.hibernate.validator.internal.metadata.aggregated.AbstractConstraintMetaData;
import org.hibernate.validator.internal.metadata.aggregated.GroupConversionHelper;
import org.hibernate.validator.internal.metadata.aggregated.MetaDataBuilder;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.descriptor.PropertyDescriptorImpl;
import org.hibernate.validator.internal.metadata.facets.Cascadable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConstrainedExecutable;
import org.hibernate.validator.internal.metadata.raw.ConstrainedField;
import org.hibernate.validator.internal.metadata.raw.ConstrainedType;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ReflectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredField;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.SetAccessibility;

public class PropertyMetaData
extends AbstractConstraintMetaData
implements Cascadable {
    private static final Log log = LoggerFactory.make();
    private final Member cascadingMember;
    private final Type cascadableType;
    private final ElementType elementType;
    private final GroupConversionHelper groupConversionHelper;
    private final Set<MetaConstraint<?>> typeArgumentsConstraints;

    private PropertyMetaData(String propertyName, Type type, Set<MetaConstraint<?>> constraints, Set<MetaConstraint<?>> typeArgumentsConstraints, Map<Class<?>, Class<?>> groupConversions, Member cascadingMember, UnwrapMode unwrapMode) {
        super(propertyName, type, constraints, ElementKind.PROPERTY, cascadingMember != null, cascadingMember != null || !constraints.isEmpty() || !typeArgumentsConstraints.isEmpty(), unwrapMode);
        if (cascadingMember != null) {
            this.cascadingMember = PropertyMetaData.getAccessible(cascadingMember);
            this.cascadableType = ReflectionHelper.typeOf(cascadingMember);
            this.elementType = cascadingMember instanceof Field ? ElementType.FIELD : ElementType.METHOD;
        } else {
            this.cascadingMember = null;
            this.cascadableType = null;
            this.elementType = ElementType.TYPE;
        }
        this.typeArgumentsConstraints = Collections.unmodifiableSet(typeArgumentsConstraints);
        this.groupConversionHelper = new GroupConversionHelper(groupConversions);
        this.groupConversionHelper.validateGroupConversions(this.isCascading(), this.toString());
    }

    private static Member getAccessible(Member original) {
        if (((AccessibleObject)((Object)original)).isAccessible()) {
            return original;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(HibernateValidatorPermission.ACCESS_PRIVATE_MEMBERS);
        }
        Class<?> clazz = original.getDeclaringClass();
        Member member = original instanceof Field ? (Member)PropertyMetaData.run(GetDeclaredField.action(clazz, original.getName())) : (Member)PropertyMetaData.run(GetDeclaredMethod.action(clazz, original.getName(), new Class[0]));
        PropertyMetaData.run(SetAccessibility.action(member));
        return member;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public Class<?> convertGroup(Class<?> from) {
        return this.groupConversionHelper.convertGroup(from);
    }

    @Override
    public Set<GroupConversionDescriptor> getGroupConversionDescriptors() {
        return this.groupConversionHelper.asDescriptors();
    }

    @Override
    public Set<MetaConstraint<?>> getTypeArgumentsConstraints() {
        return this.typeArgumentsConstraints;
    }

    @Override
    public PropertyDescriptorImpl asDescriptor(boolean defaultGroupSequenceRedefined, List<Class<?>> defaultGroupSequence) {
        return new PropertyDescriptorImpl(this.getType(), this.getName(), this.asDescriptors(this.getConstraints()), this.isCascading(), defaultGroupSequenceRedefined, defaultGroupSequence, this.getGroupConversionDescriptors());
    }

    @Override
    public Object getValue(Object parent) {
        if (this.elementType == ElementType.METHOD) {
            return ReflectionHelper.getValue((Method)this.cascadingMember, parent);
        }
        return ReflectionHelper.getValue((Field)this.cascadingMember, parent);
    }

    @Override
    public Type getCascadableType() {
        return this.cascadableType;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }

    @Override
    public String toString() {
        return "PropertyMetaData [type=" + this.getType() + ", propertyName=" + this.getName() + ", cascadingMember=[" + this.cascadingMember + "]]";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public static class Builder
    extends MetaDataBuilder {
        private static final EnumSet<ConstrainedElement.ConstrainedElementKind> SUPPORTED_ELEMENT_KINDS = EnumSet.of(ConstrainedElement.ConstrainedElementKind.TYPE, ConstrainedElement.ConstrainedElementKind.FIELD, ConstrainedElement.ConstrainedElementKind.METHOD);
        private final String propertyName;
        private final Type propertyType;
        private Member cascadingMember;
        private final Set<MetaConstraint<?>> typeArgumentsConstraints = CollectionHelper.newHashSet();
        private UnwrapMode unwrapMode = UnwrapMode.AUTOMATIC;
        private boolean unwrapModeExplicitlyConfigured = false;

        public Builder(Class<?> beanClass, ConstrainedField constrainedField, ConstraintHelper constraintHelper) {
            super(beanClass, constraintHelper);
            this.propertyName = ReflectionHelper.getPropertyName(constrainedField.getLocation().getMember());
            this.propertyType = ReflectionHelper.typeOf(constrainedField.getLocation().getMember());
            this.add(constrainedField);
        }

        public Builder(Class<?> beanClass, ConstrainedType constrainedType, ConstraintHelper constraintHelper) {
            super(beanClass, constraintHelper);
            this.propertyName = null;
            this.propertyType = null;
            this.add(constrainedType);
        }

        public Builder(Class<?> beanClass, ConstrainedExecutable constrainedMethod, ConstraintHelper constraintHelper) {
            super(beanClass, constraintHelper);
            this.propertyName = ReflectionHelper.getPropertyName(constrainedMethod.getLocation().getMember());
            this.propertyType = ReflectionHelper.typeOf(constrainedMethod.getLocation().getMember());
            this.add(constrainedMethod);
        }

        @Override
        public boolean accepts(ConstrainedElement constrainedElement) {
            if (!SUPPORTED_ELEMENT_KINDS.contains((Object)constrainedElement.getKind())) {
                return false;
            }
            if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD && !((ConstrainedExecutable)constrainedElement).isGetterMethod()) {
                return false;
            }
            return this.equals(ReflectionHelper.getPropertyName(constrainedElement.getLocation().getMember()), this.propertyName);
        }

        @Override
        public final void add(ConstrainedElement constrainedElement) {
            super.add(constrainedElement);
            UnwrapMode newUnwrapMode = constrainedElement.unwrapMode();
            if (this.unwrapModeExplicitlyConfigured) {
                if (!UnwrapMode.AUTOMATIC.equals((Object)newUnwrapMode) && !newUnwrapMode.equals((Object)this.unwrapMode)) {
                    throw log.getInconsistentValueUnwrappingConfigurationBetweenFieldAndItsGetterException(this.propertyName, this.getBeanClass().getName());
                }
            } else if (!UnwrapMode.AUTOMATIC.equals((Object)newUnwrapMode)) {
                this.unwrapMode = constrainedElement.unwrapMode();
                this.unwrapModeExplicitlyConfigured = true;
            }
            if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.FIELD) {
                this.typeArgumentsConstraints.addAll(((ConstrainedField)constrainedElement).getTypeArgumentsConstraints());
            } else if (constrainedElement.getKind() == ConstrainedElement.ConstrainedElementKind.METHOD) {
                this.typeArgumentsConstraints.addAll(((ConstrainedExecutable)constrainedElement).getTypeArgumentsConstraints());
            }
            if (constrainedElement.isCascading() && this.cascadingMember == null) {
                this.cascadingMember = constrainedElement.getLocation().getMember();
            }
        }

        @Override
        public UnwrapMode unwrapMode() {
            return this.unwrapMode;
        }

        @Override
        public PropertyMetaData build() {
            return new PropertyMetaData(this.propertyName, this.propertyType, this.adaptOriginsAndImplicitGroups(this.getConstraints()), this.typeArgumentsConstraints, this.getGroupConversions(), this.cascadingMember, this.unwrapMode());
        }

        private boolean equals(String s1, String s2) {
            return s1 != null && s1.equals(s2) || s1 == null && s2 == null;
        }
    }
}

