/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.security.Provider;
import java.util.Arrays;
import java.util.Set;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

class ProviderUtil {
    ProviderUtil() {
    }

    static Provider identifyProvider(Provider[] candidates, String name, Class<?> type, String algorithm) {
        String typeName = type.getSimpleName();
        for (Provider current : candidates) {
            if (name != null && !name.equals(current.getName()) || current.getService(typeName, algorithm) == null) continue;
            if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                ElytronSubsystemMessages.ROOT_LOGGER.tracef("Identified provider [%s] for name [%s] and algorithm [%s] between %s", new Object[]{current, name, algorithm, Arrays.toString(candidates)});
            }
            return current;
        }
        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("No provider identified for name [%s] and algorithm [%s] between %s", name, algorithm, Arrays.toString(candidates));
        }
        return null;
    }

    static boolean isServiceTypeProvided(Provider[] candidates, Class<?> type) {
        String serviceType = type.getSimpleName();
        for (Provider current : candidates) {
            Set<Provider.Service> services = current.getServices();
            if (services == null) continue;
            for (Provider.Service currentService : services) {
                if (!serviceType.equals(currentService.getType())) continue;
                if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
                    ElytronSubsystemMessages.ROOT_LOGGER.tracef("Service [%s] provided for type [%s] between %s", currentService, serviceType, Arrays.toString(candidates));
                }
                return true;
            }
        }
        if (ElytronSubsystemMessages.ROOT_LOGGER.isTraceEnabled()) {
            ElytronSubsystemMessages.ROOT_LOGGER.tracef("No service provided for type [%s] between %s", serviceType, Arrays.toString(candidates));
        }
        return false;
    }
}

