/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.messaging.activemq.BridgeAdd;
import org.wildfly.extension.messaging.activemq.BridgeControlHandler;
import org.wildfly.extension.messaging.activemq.BridgeRemove;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.InfiniteOrPositiveValidators;
import org.wildfly.extension.messaging.activemq.MessagingExtension;

public class BridgeDefinition
extends PersistentResourceDefinition {
    public static final PrimitiveListAttributeDefinition CONNECTOR_REFS = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("static-connectors").setRequired(true)).setElementValidator((ParameterValidator)new StringLengthValidator(1))).setAttributeParser(AttributeParser.STRING_LIST)).setAttributeMarshaller(AttributeMarshaller.STRING_LIST)).setAllowExpression(false)).setAlternatives(new String[]{"discovery-group"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition DISCOVERY_GROUP_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"discovery-group", (ModelType)ModelType.STRING).setRequired(true)).setAlternatives(new String[]{"static-connectors"})).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition INITIAL_CONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"initial-connect-attempts", (ModelType)ModelType.INT).setRequired(false)).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultBridgeInitialConnectAttempts()))).setAllowExpression(true)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition QUEUE_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"queue-name", (ModelType)ModelType.STRING).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PRODUCER_WINDOW_SIZE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"producer-window-size", (ModelType)ModelType.INT).setDefaultValue(new ModelNode(ActiveMQDefaultConfiguration.getDefaultBridgeProducerWindowSize()))).setMeasurementUnit(MeasurementUnit.BYTES)).setRequired(false)).setAllowExpression(true)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"password", (ModelType)ModelType.STRING, (boolean)true).setAllowExpression(true)).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultClusterPassword()))).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setAlternatives(new String[]{"credential-reference"})).build();
    public static final SimpleAttributeDefinition USER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"user", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultClusterUser()))).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).build();
    public static final ObjectTypeAttributeDefinition CREDENTIAL_REFERENCE = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)CredentialReference.getAttributeBuilder((boolean)true, (boolean)false).setRestartAllServices()).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).addAccessConstraint((AccessConstraintDefinition)MessagingExtension.MESSAGING_SECURITY_SENSITIVE_TARGET)).setAlternatives(new String[]{PASSWORD.getName()})).build();
    public static final SimpleAttributeDefinition USE_DUPLICATE_DETECTION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"use-duplicate-detection", (ModelType)ModelType.BOOLEAN).setRequired(false)).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.isDefaultBridgeDuplicateDetection()))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RECONNECT_ATTEMPTS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts", (ModelType)ModelType.INT).setRequired(false)).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultBridgeReconnectAttempts()))).setAllowExpression(true)).setValidator((ParameterValidator)InfiniteOrPositiveValidators.INT_INSTANCE)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition RECONNECT_ATTEMPTS_ON_SAME_NODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"reconnect-attempts-on-same-node", (ModelType)ModelType.INT).setRequired(false)).setDefaultValue(new ModelNode().set(ActiveMQDefaultConfiguration.getDefaultBridgeConnectSameNode()))).setAllowExpression(true)).setRestartAllServices()).build();
    public static final SimpleAttributeDefinition FORWARDING_ADDRESS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"forwarding-address", (ModelType)ModelType.STRING).setRequired(false)).setAllowExpression(true)).setRestartAllServices()).build();
    public static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{QUEUE_NAME, FORWARDING_ADDRESS, CommonAttributes.HA, CommonAttributes.FILTER, CommonAttributes.TRANSFORMER_CLASS_NAME, CommonAttributes.MIN_LARGE_MESSAGE_SIZE, CommonAttributes.CHECK_PERIOD, CommonAttributes.CONNECTION_TTL, CommonAttributes.RETRY_INTERVAL, CommonAttributes.RETRY_INTERVAL_MULTIPLIER, CommonAttributes.MAX_RETRY_INTERVAL, INITIAL_CONNECT_ATTEMPTS, RECONNECT_ATTEMPTS, RECONNECT_ATTEMPTS_ON_SAME_NODE, USE_DUPLICATE_DETECTION, PRODUCER_WINDOW_SIZE, CommonAttributes.BRIDGE_CONFIRMATION_WINDOW_SIZE, USER, PASSWORD, CREDENTIAL_REFERENCE, CONNECTOR_REFS, DISCOVERY_GROUP_NAME};
    private final boolean registerRuntimeOnly;

    BridgeDefinition(boolean registerRuntimeOnly) {
        super(MessagingExtension.BRIDGE_PATH, MessagingExtension.getResourceDescriptionResolver("bridge"), (OperationStepHandler)BridgeAdd.INSTANCE, (OperationStepHandler)BridgeRemove.INSTANCE);
        this.registerRuntimeOnly = registerRuntimeOnly;
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(ATTRIBUTES);
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        ReloadRequiredWriteAttributeHandler reloadRequiredWriteAttributeHandler = new ReloadRequiredWriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attr : ATTRIBUTES) {
            if (attr.getFlags().contains(AttributeAccess.Flag.STORAGE_RUNTIME)) continue;
            registry.registerReadWriteAttribute(attr, null, (OperationStepHandler)reloadRequiredWriteAttributeHandler);
        }
        BridgeControlHandler.INSTANCE.registerAttributes(registry);
    }

    public void registerOperations(ManagementResourceRegistration registry) {
        super.registerOperations(registry);
        if (this.registerRuntimeOnly) {
            BridgeControlHandler.INSTANCE.registerOperations(registry, this.getResourceDescriptionResolver());
        }
    }
}

