/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.deployment;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.as.cli.Attachments;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.impl.aesh.cmd.deployment.AbstractDeployContentCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeploymentCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.EnableCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.OptionActivators;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.impl.aesh.cmd.security.ControlledCommandActivator;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;

@CommandDefinition(name="deploy-file", description="", activator=ControlledCommandActivator.class)
public class DeployFileCommand
extends AbstractDeployContentCommand {
    @Option(hasValue=false, activator=OptionActivators.UnmanagedActivator.class, required=false)
    public boolean unmanaged;
    @Option(hasValue=true, required=false, completer=EnableCommand.NameCompleter.class, activator=OptionActivators.NameActivator.class)
    public String name;
    @Argument(required=true)
    public File file;

    public DeployFileCommand(CommandContext ctx, Permissions permissions) {
        super(ctx, permissions);
    }

    @Deprecated
    public DeployFileCommand(CommandContext ctx) {
        this(ctx, (Permissions)null);
    }

    @Override
    protected void checkArgument() throws CommandException {
        if (this.file == null) {
            throw new CommandException("No deployment file");
        }
        if (!this.file.exists()) {
            throw new CommandException("Path " + this.file.getAbsolutePath() + " doesn't exist.");
        }
        if (!this.unmanaged && this.file.isDirectory()) {
            throw new CommandException(this.file.getAbsolutePath() + " is a directory.");
        }
    }

    @Override
    protected String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.file.getName();
    }

    @Override
    protected void addContent(CommandContext context, ModelNode content) throws OperationFormatException {
        if (this.unmanaged) {
            content.get("path").set(this.file.getAbsolutePath());
            content.get("archive").set(this.file.isFile());
        } else if (context.getBatchManager().isBatchActive()) {
            Attachments attachments = context.getBatchManager().getActiveBatch().getAttachments();
            int index = attachments.addFileAttachment(this.file.getAbsolutePath());
            content.get("input-stream-index").set(index);
        } else {
            content.get("input-stream-index").set(0);
        }
    }

    @Override
    protected List<String> getServerGroups(CommandContext ctx) throws CommandFormatException {
        return DeploymentCommand.getServerGroups(ctx, ctx.getModelControllerClient(), this.allServerGroups, this.serverGroups, this.file);
    }

    @Override
    protected String getCommandName() {
        return "deploy-file";
    }

    @Override
    protected ModelNode execute(CommandContext ctx, ModelNode request) throws IOException {
        ModelNode result;
        if (!this.unmanaged) {
            OperationBuilder op = new OperationBuilder(request);
            op.addFileAsAttachment(this.file);
            request.get("content").get(0).get("input-stream-index").set(0);
            try (Operation operation = op.build();){
                result = ctx.getModelControllerClient().execute(operation);
            }
        } else {
            result = ctx.getModelControllerClient().execute(request);
        }
        return result;
    }
}

