/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class Base64InputStream
extends InputStream {
    private static final int[] IA = new int[256];
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public Base64InputStream(String encodedString) {
        this.buf = this.decode(encodedString);
        this.pos = 0;
        this.count = this.buf.length;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
    }

    private byte[] decode(String source) {
        int sIx;
        int sLen = source.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[source.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[source.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = source.charAt(eIx) == '=' ? (source.charAt(eIx - 1) == '=' ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (source.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[source.charAt(sIx++)] << 18 | IA[source.charAt(sIx++)] << 12 | IA[source.charAt(sIx++)] << 6 | IA[source.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[source.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (int i = 0; i < iS; ++i) {
            Base64InputStream.IA[Base64InputStream.CA[i]] = i;
        }
        Base64InputStream.IA[61] = 0;
    }
}

