/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;
import org.wildfly.security.sasl.util.PrivilegedSaslClient;

public final class PrivilegedSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final AccessControlContext context;

    public PrivilegedSaslClientFactory(SaslClientFactory delegate) {
        this(delegate, AccessController.getContext());
    }

    PrivilegedSaslClientFactory(SaslClientFactory delegate, AccessControlContext context) {
        super(delegate);
        this.context = context;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslClient saslClient;
        try {
            saslClient = AccessController.doPrivileged(() -> this.delegate.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, cbh), this.context);
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | SaslException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
        return saslClient == null ? null : new PrivilegedSaslClient(saslClient, this.context);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof PrivilegedSaslClientFactory && this.equals((PrivilegedSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof PrivilegedSaslClientFactory && this.equals((PrivilegedSaslClientFactory)other);
    }

    public boolean equals(PrivilegedSaslClientFactory other) {
        return super.equals(other) && this.context.equals(other.context);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(super.calculateHashCode(), this.getClass().hashCode()), this.context.hashCode());
    }
}

