/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.ForkChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolServiceNameProvider;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.jgroups.JChannel;
import org.jgroups.protocols.FORK;
import org.jgroups.stack.ProtocolStack;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.SuppliedValueService;
import org.wildfly.clustering.service.ValueDependency;

public class ForkChannelFactoryBuilder
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<ChannelFactory> {
    private final PathAddress address;
    private volatile List<ValueDependency<ProtocolConfiguration>> protocols;
    private volatile ValueDependency<JChannel> parentChannel;
    private volatile ValueDependency<ChannelFactory> parentFactory;

    public ForkChannelFactoryBuilder(Capability capability, PathAddress address) {
        super(capability, address);
        this.address = address;
    }

    public ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        Supplier<ChannelFactory> supplier = () -> new ForkChannelFactory((JChannel)this.parentChannel.getValue(), (ChannelFactory)this.parentFactory.getValue(), this.protocols.stream().map(Value::getValue).map(protocol -> protocol).collect(Collectors.toList()));
        Consumer<ChannelFactory> destroyer = factory -> {
            ProtocolStack stack = ((JChannel)this.parentChannel.getValue()).getProtocolStack();
            FORK fork = (FORK)stack.findProtocol(FORK.class);
            fork.remove(this.address.getLastElement().getValue());
        };
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new SuppliedValueService(Function.identity(), supplier, destroyer)).setInitialMode(ServiceController.Mode.PASSIVE);
        Stream.concat(Stream.of(this.parentChannel, this.parentFactory), this.protocols.stream()).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    public Builder<ChannelFactory> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PlaceholderResource resource = context.getCurrentAddress().equals(this.address) ? context.readResourceFromRoot(this.address, false) : PlaceholderResource.INSTANCE;
        this.protocols = resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).stream().map(entry -> new InjectedValueDependency((ServiceNameProvider)new ProtocolServiceNameProvider(this.address, entry.getPathElement()), ProtocolConfiguration.class)).collect(Collectors.toList());
        String channelName = this.address.getParent().getLastElement().getValue();
        this.parentChannel = new InjectedValueDependency(JGroupsRequirement.CHANNEL.getServiceName(context, channelName), JChannel.class);
        this.parentFactory = new InjectedValueDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(context, channelName), ChannelFactory.class);
        return this;
    }
}

