/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SingletonProtocolServiceNameProvider;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ValueDependency;

public class JChannelFactoryBuilder
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<ChannelFactory>,
ProtocolStackConfiguration {
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
    private final PathAddress address;
    private volatile boolean statisticsEnabled;
    private volatile ValueDependency<TransportConfiguration> transport = null;
    private volatile List<ValueDependency<ProtocolConfiguration>> protocols = null;
    private volatile ValueDependency<RelayConfiguration> relay = null;

    public JChannelFactoryBuilder(PathAddress address) {
        super((Capability)StackResourceDefinition.Capability.JCHANNEL_FACTORY, address);
        this.address = address;
    }

    public ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        Value value = () -> new JChannelFactory(this);
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService(value)).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.environment).setInitialMode(ServiceController.Mode.ON_DEMAND);
        Stream.concat(Stream.of(this.transport, this.relay).filter(Objects::nonNull), this.protocols.stream()).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    public Builder<ChannelFactory> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.statisticsEnabled = StackResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        Resource resource = context.readResourceFromRoot(this.address, false);
        Optional<PathElement> transport = resource.getChildren(TransportResourceDefinition.WILDCARD_PATH.getKey()).stream().map(Resource.ResourceEntry::getPathElement).findFirst();
        if (!transport.isPresent()) {
            throw JGroupsLogger.ROOT_LOGGER.transportNotDefined(this.getName());
        }
        this.transport = new InjectedValueDependency((ServiceNameProvider)new SingletonProtocolServiceNameProvider(this.address, transport.get()), TransportConfiguration.class);
        this.protocols = resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).stream().map(entry -> new InjectedValueDependency((ServiceNameProvider)new ProtocolServiceNameProvider(this.address, entry.getPathElement()), ProtocolConfiguration.class)).collect(Collectors.toList());
        this.relay = resource.hasChild(RelayResourceDefinition.PATH) ? new InjectedValueDependency((ServiceNameProvider)new SingletonProtocolServiceNameProvider(this.address, RelayResourceDefinition.PATH), RelayConfiguration.class) : null;
        return this;
    }

    public String getName() {
        return this.address.getLastElement().getValue();
    }

    public TransportConfiguration<? extends TP> getTransport() {
        return (TransportConfiguration)this.transport.getValue();
    }

    public List<ProtocolConfiguration<? extends Protocol>> getProtocols() {
        ArrayList<ProtocolConfiguration<? extends Protocol>> protocols = new ArrayList<ProtocolConfiguration<? extends Protocol>>(this.protocols.size());
        for (Value value : this.protocols) {
            ProtocolConfiguration protocol = (ProtocolConfiguration)value.getValue();
            protocols.add((ProtocolConfiguration<? extends Protocol>)protocol);
        }
        return protocols;
    }

    public String getNodeName() {
        return ((ServerEnvironment)this.environment.getValue()).getNodeName();
    }

    public Optional<RelayConfiguration> getRelay() {
        return this.relay != null ? Optional.of(this.relay.getValue()) : Optional.empty();
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }
}

