/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.api;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;

public class CounterConfiguration {
    public static final AdvancedExternalizer<CounterConfiguration> EXTERNALIZER = new Externalize();
    private final long initialValue;
    private final long upperBound;
    private final long lowerBound;
    private final int concurrencyLevel;
    private final CounterType type;
    private final Storage storage;

    private CounterConfiguration(long initialValue, long lowerBound, long upperBound, int concurrencyLevel, CounterType type, Storage storage) {
        this.initialValue = initialValue;
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
        this.concurrencyLevel = concurrencyLevel;
        this.type = type;
        this.storage = storage;
    }

    public static Builder builder(CounterType type) {
        return new Builder(Objects.requireNonNull(type));
    }

    public long initialValue() {
        return this.initialValue;
    }

    public long upperBound() {
        return this.upperBound;
    }

    public long lowerBound() {
        return this.lowerBound;
    }

    public CounterType type() {
        return this.type;
    }

    public int concurrencyLevel() {
        return this.concurrencyLevel;
    }

    public Storage storage() {
        return this.storage;
    }

    public String toString() {
        return "CounterConfiguration{initialValue=" + this.initialValue + ", upperBound=" + this.upperBound + ", lowerBound=" + this.lowerBound + ", concurrencyLevel=" + this.concurrencyLevel + ", type=" + (Object)((Object)this.type) + ", storage=" + (Object)((Object)this.storage) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterConfiguration that = (CounterConfiguration)o;
        return this.initialValue == that.initialValue && this.upperBound == that.upperBound && this.lowerBound == that.lowerBound && this.concurrencyLevel == that.concurrencyLevel && this.type == that.type && this.storage == that.storage;
    }

    public int hashCode() {
        int result = (int)(this.initialValue ^ this.initialValue >>> 32);
        result = 31 * result + (int)(this.upperBound ^ this.upperBound >>> 32);
        result = 31 * result + (int)(this.lowerBound ^ this.lowerBound >>> 32);
        result = 31 * result + this.concurrencyLevel;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.storage.hashCode();
        return result;
    }

    private static class Externalize
    implements AdvancedExternalizer<CounterConfiguration> {
        private Externalize() {
        }

        @Override
        public Set<Class<? extends CounterConfiguration>> getTypeClasses() {
            return Collections.singleton(CounterConfiguration.class);
        }

        @Override
        public Integer getId() {
            return 2000;
        }

        @Override
        public void writeObject(ObjectOutput output, CounterConfiguration object) throws IOException {
            MarshallUtil.marshallEnum(object.type, output);
            MarshallUtil.marshallEnum(object.storage, output);
            output.writeLong(object.initialValue);
            switch (object.type) {
                case BOUNDED_STRONG: {
                    output.writeLong(object.lowerBound);
                    output.writeLong(object.upperBound);
                    break;
                }
                case WEAK: {
                    UnsignedNumeric.writeUnsignedInt(output, object.concurrencyLevel);
                    break;
                }
            }
        }

        @Override
        public CounterConfiguration readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            CounterType type = MarshallUtil.unmarshallEnum(input, CounterType::valueOf);
            Storage storage = MarshallUtil.unmarshallEnum(input, Storage::valueOf);
            long initialValue = input.readLong();
            long lowerBound = 0L;
            long upperBound = 0L;
            int concurrencyLevel = 0;
            switch (type) {
                case BOUNDED_STRONG: {
                    lowerBound = input.readLong();
                    upperBound = input.readLong();
                    break;
                }
                case WEAK: {
                    concurrencyLevel = UnsignedNumeric.readUnsignedInt(input);
                    break;
                }
            }
            return new CounterConfiguration(initialValue, lowerBound, upperBound, concurrencyLevel, type, storage);
        }
    }

    public static class Builder {
        private final CounterType type;
        private long initialValue = 0L;
        private long lowerBound = Long.MIN_VALUE;
        private long upperBound = Long.MAX_VALUE;
        private Storage storage = Storage.VOLATILE;
        private int concurrencyLevel = 64;

        private Builder(CounterType type) {
            this.type = type;
        }

        public Builder initialValue(long initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public Builder lowerBound(long lowerBound) {
            this.lowerBound = lowerBound;
            return this;
        }

        public Builder upperBound(long upperBound) {
            this.upperBound = upperBound;
            return this;
        }

        public Builder storage(Storage storage) {
            this.storage = Objects.requireNonNull(storage);
            return this;
        }

        public Builder concurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public CounterConfiguration build() {
            return new CounterConfiguration(this.initialValue, this.lowerBound, this.upperBound, this.concurrencyLevel, this.type, this.storage);
        }
    }
}

