/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh;

import java.util.Collections;
import java.util.List;
import org.aesh.complete.AeshCompleteOperation;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.completion.CompletionHandler;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.impl.CLICommandCompleter;
import org.jboss.as.cli.impl.CommandContextImpl;
import org.jboss.as.cli.impl.aesh.AeshCommands;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.jboss.logging.Logger;

class CLICompletionHandler
extends CompletionHandler<AeshCompleteOperation>
implements Completion<AeshCompleteOperation>,
CommandLineCompleter,
CLICommandCompleter.Completer {
    private static final Logger LOG = Logger.getLogger(CLICompletionHandler.class);
    private final AeshCommands aeshCommands;
    private final CommandContextImpl ctx;
    private final CLICommandCompleter cliCompleter = new CLICommandCompleter();
    private CLICommandCompleter.Completer legacyCommandCompleter;

    CLICompletionHandler(AeshCommands aeshCommands, CommandContextImpl ctx) {
        this.aeshCommands = aeshCommands;
        this.ctx = ctx;
    }

    public void setLegacyCommandCompleter(CLICommandCompleter.Completer legacyCommandCompleter) {
        this.legacyCommandCompleter = legacyCommandCompleter;
    }

    public void complete(AeshCompleteOperation co) {
        LOG.debugf("Completing {0}", (Object)co.getBuffer());
        this.cliCompleter.complete(this.ctx, co, this);
        LOG.debugf("Completion candidates {0}", (Object)co.getCompletionCandidates());
    }

    public AeshCompleteOperation createCompleteOperation(String buffer, int cursor) {
        return new AeshCompleteOperation(this.aeshCommands.getAeshContext(), buffer, cursor);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        AeshCompleteOperation co = new AeshCompleteOperation(this.aeshCommands.getAeshContext(), buffer, cursor);
        this.complete(co);
        for (TerminalString ts : co.getCompletionCandidates()) {
            candidates.add(ts.getCharacters());
        }
        if (co.getCompletionCandidates().isEmpty()) {
            return -1;
        }
        Collections.sort(candidates);
        return co.getOffset();
    }

    @Override
    public void addAllCommandNames(CommandContext ctx, AeshCompleteOperation op) {
        op.addCompletionCandidate(OperationFormat.INSTANCE.getAddressOperationSeparator());
        op.addCompletionCandidates(this.aeshCommands.getRegistry().getAvailableAeshCommands());
    }

    @Override
    public void complete(CommandContext ctx, DefaultCallbackHandler parsedCmd, AeshCompleteOperation op) {
        StateParser.SubstitutedLine substitutions = parsedCmd.getSubstitutions();
        AeshCompleteOperation co = new AeshCompleteOperation(this.aeshCommands.getAeshContext(), parsedCmd.getSubstitutedLine(), substitutions.getSubstitutedOffset(op.getCursor()));
        if (parsedCmd.hasOperator()) {
            this.completeAeshCommands(co);
        } else if (parsedCmd.getFormat() == OperationFormat.INSTANCE) {
            this.completeLegacyCommands(ctx, parsedCmd, co);
        } else if (this.aeshCommands.getRegistry().isLegacyCommand(parsedCmd.getOperationName())) {
            if (!parsedCmd.hasProperties() && !parsedCmd.getOriginalLine().endsWith(" ")) {
                this.completeAeshCommands(co);
            } else {
                this.completeLegacyCommands(ctx, parsedCmd, co);
            }
        } else {
            this.completeAeshCommands(co);
        }
        if (!co.getCompletionCandidates().isEmpty()) {
            int correctedValueOffset = substitutions.getOriginalOffset(co.getOffset());
            co.setOffset(correctedValueOffset);
            CLICommandCompleter.transferOperation(co, op);
        }
    }

    private void completeAeshCommands(AeshCompleteOperation co) {
        this.aeshCommands.complete(co);
    }

    private void completeLegacyCommands(CommandContext ctx, DefaultCallbackHandler parsedCmd, AeshCompleteOperation co) {
        String buffer;
        this.legacyCommandCompleter.complete(ctx, parsedCmd, co);
        String string = buffer = ctx.getArgumentsString() == null ? co.getBuffer() : ctx.getArgumentsString() + co.getBuffer();
        if (co.getCompletionCandidates().size() == 1 && ((TerminalString)co.getCompletionCandidates().get(0)).getCharacters().startsWith(buffer)) {
            co.doAppendSeparator(true);
        } else if (!co.getCompletionCandidates().isEmpty()) {
            co.doAppendSeparator(false);
        }
    }
}

