/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider.jwt;

import java.security.KeyStore;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.sts.cache.CacheUtils;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenProviderResponse;
import org.apache.cxf.sts.token.provider.jwt.DefaultJWTClaimsProvider;
import org.apache.cxf.sts.token.provider.jwt.JWTClaimsProvider;
import org.apache.cxf.sts.token.provider.jwt.JWTClaimsProviderParameters;
import org.apache.cxf.sts.token.realm.RealmProperties;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSPasswordCallback;

public class JWTTokenProvider
implements TokenProvider {
    public static final String JWT_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:jwt";
    private static final Logger LOG = LogUtils.getL7dLogger(JWTTokenProvider.class);
    private boolean signToken = true;
    private Map<String, RealmProperties> realmMap = new HashMap<String, RealmProperties>();
    private JWTClaimsProvider jwtClaimsProvider = new DefaultJWTClaimsProvider();

    @Override
    public boolean canHandleToken(String tokenType) {
        return this.canHandleToken(tokenType, null);
    }

    @Override
    public boolean canHandleToken(String tokenType, String realm) {
        if (realm != null && !this.realmMap.containsKey(realm)) {
            return false;
        }
        return JWT_TOKEN_TYPE.equals(tokenType);
    }

    @Override
    public TokenProviderResponse createToken(TokenProviderParameters tokenParameters) {
        TokenRequirements tokenRequirements = tokenParameters.getTokenRequirements();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Handling token of type: " + tokenRequirements.getTokenType());
        }
        String realm = tokenParameters.getRealm();
        RealmProperties jwtRealm = null;
        if (realm != null && this.realmMap.containsKey(realm)) {
            jwtRealm = this.realmMap.get(realm);
        }
        JWTClaimsProviderParameters jwtClaimsProviderParameters = new JWTClaimsProviderParameters();
        jwtClaimsProviderParameters.setProviderParameters(tokenParameters);
        if (jwtRealm != null) {
            jwtClaimsProviderParameters.setIssuer(jwtRealm.getIssuer());
        }
        JwtClaims claims = this.jwtClaimsProvider.getJwtClaims(jwtClaimsProviderParameters);
        try {
            String tokenData = this.signToken(claims, jwtRealm, tokenParameters.getStsProperties());
            if (tokenParameters.isEncryptToken()) {
                tokenData = this.encryptToken(tokenData, new JweHeaders(), tokenParameters.getStsProperties(), tokenParameters.getEncryptionProperties(), tokenParameters.getKeyRequirements());
            }
            TokenProviderResponse response = new TokenProviderResponse();
            response.setToken(tokenData);
            response.setTokenId(claims.getTokenId());
            if (claims.getIssuedAt() > 0L) {
                response.setCreated(Instant.ofEpochMilli(claims.getIssuedAt() * 1000L));
            }
            Instant expires = null;
            if (claims.getExpiryTime() > 0L) {
                expires = Instant.ofEpochMilli(claims.getExpiryTime() * 1000L);
                response.setExpires(expires);
            }
            if (this.signToken && tokenParameters.getTokenStore() != null) {
                SecurityToken securityToken = CacheUtils.createSecurityTokenForStorage(null, claims.getTokenId(), expires, tokenParameters.getPrincipal(), tokenParameters.getRealm(), tokenParameters.getTokenRequirements().getRenewing());
                securityToken.setData(tokenData.getBytes());
                String signature = tokenData.substring(tokenData.lastIndexOf(".") + 1);
                CacheUtils.storeTokenInCache(securityToken, tokenParameters.getTokenStore(), signature.getBytes());
            }
            LOG.fine("JWT Token successfully created");
            return response;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.log(Level.WARNING, "", e);
            throw new STSException("Can't serialize JWT token", (Throwable)e, STSException.REQUEST_FAILED);
        }
    }

    public boolean isSignToken() {
        return this.signToken;
    }

    public void setSignToken(boolean signToken) {
        this.signToken = signToken;
    }

    public void setRealmMap(Map<String, ? extends RealmProperties> realms) {
        this.realmMap.clear();
        this.realmMap.putAll(realms);
    }

    public Map<String, RealmProperties> getRealmMap() {
        return Collections.unmodifiableMap(this.realmMap);
    }

    public JWTClaimsProvider getJwtClaimsProvider() {
        return this.jwtClaimsProvider;
    }

    public void setJwtClaimsProvider(JWTClaimsProvider jwtClaimsProvider) {
        this.jwtClaimsProvider = jwtClaimsProvider;
    }

    private String signToken(JwtClaims claims, RealmProperties jwtRealm, STSPropertiesMBean stsProperties) throws Exception {
        if (this.signToken) {
            Crypto signatureCrypto = stsProperties.getSignatureCrypto();
            CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
            SignatureProperties signatureProperties = stsProperties.getSignatureProperties();
            String alias = stsProperties.getSignatureUsername();
            if (jwtRealm != null) {
                if (jwtRealm.getSignatureCrypto() != null) {
                    LOG.fine("SAMLRealm signature keystore used");
                    signatureCrypto = jwtRealm.getSignatureCrypto();
                    callbackHandler = jwtRealm.getCallbackHandler();
                    alias = jwtRealm.getSignatureAlias();
                }
                if (jwtRealm.getSignatureProperties() != null) {
                    signatureProperties = jwtRealm.getSignatureProperties();
                }
            }
            String signatureAlgorithm = signatureProperties.getSignatureAlgorithm();
            try {
                SignatureAlgorithm.getAlgorithm((String)signatureAlgorithm);
            }
            catch (IllegalArgumentException ex) {
                signatureAlgorithm = SignatureAlgorithm.RS256.name();
            }
            if ((alias == null || "".equals(alias)) && signatureCrypto != null) {
                alias = signatureCrypto.getDefaultX509Identifier();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Signature alias is null so using default alias: " + alias);
                }
            }
            String password = null;
            if (callbackHandler != null) {
                WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(alias, 3)};
                callbackHandler.handle((Callback[])cb);
                password = cb[0].getPassword();
            }
            Properties signingProperties = new Properties();
            signingProperties.put("rs.security.signature.algorithm", signatureAlgorithm);
            if (alias != null) {
                signingProperties.put("rs.security.keystore.alias", alias);
            }
            if (password == null) {
                throw new STSException("Can't get the password", STSException.REQUEST_FAILED);
            }
            signingProperties.put("rs.security.key.password", password);
            if (!(signatureCrypto instanceof Merlin)) {
                throw new STSException("Can't get the keystore", STSException.REQUEST_FAILED);
            }
            KeyStore keystore = ((Merlin)signatureCrypto).getKeyStore();
            signingProperties.put("rs.security.keystore", keystore);
            JwsHeaders jwsHeaders = new JwsHeaders(signingProperties);
            JwsJwtCompactProducer jws = new JwsJwtCompactProducer(jwsHeaders, claims);
            JwsSignatureProvider sigProvider = JwsUtils.loadSignatureProvider((Properties)signingProperties, (JwsHeaders)jwsHeaders);
            return jws.signWith(sigProvider);
        }
        JwsHeaders jwsHeaders = new JwsHeaders(SignatureAlgorithm.NONE);
        JwsJwtCompactProducer jws = new JwsJwtCompactProducer(jwsHeaders, claims);
        return jws.getSignedEncodedJws();
    }

    private String encryptToken(String token, JweHeaders jweHeaders, STSPropertiesMBean stsProperties, EncryptionProperties encryptionProperties, KeyRequirements keyRequirements) throws Exception {
        Properties encProperties = new Properties();
        String name = encryptionProperties.getEncryptionName();
        if (name == null) {
            name = stsProperties.getEncryptionUsername();
        }
        if (name == null) {
            LOG.fine("No encryption alias is configured");
            return token;
        }
        encProperties.put("rs.security.keystore.alias", name);
        String encryptionAlgorithm = encryptionProperties.getEncryptionAlgorithm();
        try {
            ContentAlgorithm.getAlgorithm((String)encryptionAlgorithm);
        }
        catch (IllegalArgumentException ex) {
            encryptionAlgorithm = ContentAlgorithm.A128GCM.name();
        }
        encProperties.put("rs.security.encryption.content.algorithm", encryptionAlgorithm);
        String keyWrapAlgorithm = encryptionProperties.getKeyWrapAlgorithm();
        try {
            KeyAlgorithm.getAlgorithm((String)keyWrapAlgorithm);
        }
        catch (IllegalArgumentException ex) {
            keyWrapAlgorithm = KeyAlgorithm.RSA_OAEP.name();
        }
        encProperties.put("rs.security.encryption.key.algorithm", keyWrapAlgorithm);
        Crypto encryptionCrypto = stsProperties.getEncryptionCrypto();
        if (!(encryptionCrypto instanceof Merlin)) {
            throw new STSException("Can't get the keystore", STSException.REQUEST_FAILED);
        }
        KeyStore keystore = ((Merlin)encryptionCrypto).getKeyStore();
        encProperties.put("rs.security.keystore", keystore);
        JweEncryptionProvider encProvider = JweUtils.loadEncryptionProvider((Properties)encProperties, (JweHeaders)jweHeaders);
        return encProvider.encrypt(StringUtils.toBytesUTF8((String)token), null);
    }
}

