/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.IntCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.stream.impl.DistributedCacheStream;
import org.infinispan.stream.impl.IntermediateCacheStreamSupplier;
import org.infinispan.stream.impl.IntermediateDoubleCacheStream;
import org.infinispan.stream.impl.IntermediateIntCacheStream;
import org.infinispan.stream.impl.IntermediateLongCacheStream;
import org.infinispan.stream.impl.IntermediateType;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.local.LocalDoubleCacheStream;
import org.infinispan.stream.impl.local.LocalIntCacheStream;
import org.infinispan.stream.impl.local.LocalLongCacheStream;

public class IntermediateCacheStream<R>
implements CacheStream<R> {
    private BaseCacheStream remoteStream;
    private final IntermediateType type;
    private LocalCacheStream<R> localStream;
    private final IntermediateCacheStreamSupplier supplier;

    public IntermediateCacheStream(DistributedCacheStream<R> remoteStream) {
        this.remoteStream = remoteStream;
        this.type = IntermediateType.REF;
        this.supplier = new IntermediateCacheStreamSupplier(this.type, remoteStream);
        this.localStream = new LocalCacheStream(this.supplier, remoteStream.parallel, remoteStream.registry);
    }

    public IntermediateCacheStream(BaseCacheStream remoteStream, IntermediateType type, LocalCacheStream<R> localStream, IntermediateCacheStreamSupplier supplier) {
        this.remoteStream = remoteStream;
        this.type = type;
        this.localStream = localStream;
        this.supplier = supplier;
    }

    @Override
    public CacheStream<R> sequentialDistribution() {
        this.remoteStream = this.remoteStream.sequentialDistribution();
        return this;
    }

    @Override
    public CacheStream<R> parallelDistribution() {
        this.remoteStream = this.remoteStream.parallelDistribution();
        return this;
    }

    @Override
    public CacheStream<R> filterKeySegments(Set<Integer> segments) {
        this.remoteStream = this.remoteStream.filterKeySegments(segments);
        return this;
    }

    @Override
    public CacheStream<R> filterKeys(Set<?> keys) {
        this.remoteStream = this.remoteStream.filterKeys(keys);
        return this;
    }

    @Override
    public CacheStream<R> distributedBatchSize(int batchSize) {
        this.remoteStream = this.remoteStream.distributedBatchSize(batchSize);
        return this;
    }

    @Override
    public CacheStream<R> segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        throw new UnsupportedOperationException("Segment completion listener is only supported when no intermediate operation is provided (sorted, distinct, limit, skip)");
    }

    @Override
    public CacheStream<R> disableRehashAware() {
        this.remoteStream = this.remoteStream.disableRehashAware();
        return this;
    }

    @Override
    public CacheStream<R> timeout(long timeout, TimeUnit unit) {
        this.remoteStream = this.remoteStream.timeout(timeout, unit);
        return this;
    }

    @Override
    public boolean isParallel() {
        return this.localStream.isParallel();
    }

    @Override
    public CacheStream<R> sorted() {
        this.localStream = this.localStream.sorted();
        return this;
    }

    @Override
    public CacheStream<R> sorted(Comparator<? super R> comparator) {
        this.localStream = this.localStream.sorted((Comparator)comparator);
        return this;
    }

    @Override
    public CacheStream<R> limit(long maxSize) {
        this.localStream = this.localStream.limit(maxSize);
        return this;
    }

    @Override
    public CacheStream<R> skip(long n) {
        this.localStream = this.localStream.skip(n);
        return this;
    }

    @Override
    public CacheStream<R> peek(Consumer<? super R> action) {
        this.localStream = this.localStream.peek((Consumer)action);
        return this;
    }

    @Override
    public CacheStream<R> distinct() {
        this.localStream = this.localStream.distinct();
        return this;
    }

    @Override
    public CacheStream<R> filter(Predicate<? super R> predicate) {
        this.localStream = this.localStream.filter((Predicate)predicate);
        return this;
    }

    @Override
    public <R1> CacheStream<R1> map(Function<? super R, ? extends R1> mapper) {
        this.localStream = this.localStream.map((Function)mapper);
        return this;
    }

    @Override
    public DoubleCacheStream mapToDouble(ToDoubleFunction<? super R> mapper) {
        return new IntermediateDoubleCacheStream(this.remoteStream, this.type, (LocalDoubleCacheStream)this.localStream.mapToDouble((ToDoubleFunction)mapper), this.supplier);
    }

    @Override
    public IntCacheStream mapToInt(ToIntFunction<? super R> mapper) {
        return new IntermediateIntCacheStream(this.remoteStream, this.type, (LocalIntCacheStream)this.localStream.mapToInt((ToIntFunction)mapper), this.supplier);
    }

    @Override
    public LongCacheStream mapToLong(ToLongFunction<? super R> mapper) {
        return new IntermediateLongCacheStream(this.remoteStream, this.type, (LocalLongCacheStream)this.localStream.mapToLong((ToLongFunction)mapper), this.supplier);
    }

    @Override
    public <R1> CacheStream<R1> flatMap(Function<? super R, ? extends Stream<? extends R1>> mapper) {
        this.localStream = this.localStream.flatMap(mapper);
        return this;
    }

    @Override
    public DoubleCacheStream flatMapToDouble(Function<? super R, ? extends DoubleStream> mapper) {
        return new IntermediateDoubleCacheStream(this.remoteStream, this.type, (LocalDoubleCacheStream)this.localStream.flatMapToDouble(mapper), this.supplier);
    }

    @Override
    public IntCacheStream flatMapToInt(Function<? super R, ? extends IntStream> mapper) {
        return new IntermediateIntCacheStream(this.remoteStream, this.type, (LocalIntCacheStream)this.localStream.flatMapToInt(mapper), this.supplier);
    }

    @Override
    public LongCacheStream flatMapToLong(Function<? super R, ? extends LongStream> mapper) {
        return new IntermediateLongCacheStream(this.remoteStream, this.type, (LocalLongCacheStream)this.localStream.flatMapToLong(mapper), this.supplier);
    }

    @Override
    public CacheStream<R> parallel() {
        this.remoteStream = (BaseCacheStream)this.remoteStream.parallel();
        this.localStream = (LocalCacheStream)this.localStream.parallel();
        return this;
    }

    @Override
    public CacheStream<R> sequential() {
        this.remoteStream = (BaseCacheStream)this.remoteStream.sequential();
        this.localStream = (LocalCacheStream)this.localStream.sequential();
        return this;
    }

    @Override
    public CacheStream<R> unordered() {
        this.localStream = (LocalCacheStream)this.localStream.unordered();
        return this;
    }

    @Override
    public void forEach(Consumer<? super R> action) {
        this.localStream.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super R> action) {
        this.localStream.forEachOrdered(action);
    }

    @Override
    public <K, V> void forEach(BiConsumer<Cache<K, V>, ? super R> action) {
        this.localStream.forEach(action);
    }

    @Override
    public R reduce(R identity, BinaryOperator<R> accumulator) {
        return this.localStream.reduce(identity, accumulator);
    }

    @Override
    public Optional<R> reduce(BinaryOperator<R> accumulator) {
        return this.localStream.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super R, U> accumulator, BinaryOperator<U> combiner) {
        return this.localStream.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R1, A> R1 collect(Collector<? super R, A, R1> collector) {
        return this.localStream.collect(collector);
    }

    @Override
    public <R1> R1 collect(Supplier<R1> supplier, BiConsumer<R1, ? super R> accumulator, BiConsumer<R1, R1> combiner) {
        return this.localStream.collect(supplier, accumulator, combiner);
    }

    @Override
    public Optional<R> max(Comparator<? super R> comparator) {
        return this.localStream.max(comparator);
    }

    @Override
    public Optional<R> min(Comparator<? super R> comparator) {
        return this.localStream.min(comparator);
    }

    @Override
    public long count() {
        return this.localStream.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super R> predicate) {
        return this.localStream.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super R> predicate) {
        return this.localStream.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super R> predicate) {
        return this.localStream.noneMatch(predicate);
    }

    @Override
    public Optional<R> findFirst() {
        return this.localStream.findFirst();
    }

    @Override
    public Optional<R> findAny() {
        return this.localStream.findAny();
    }

    @Override
    public Iterator<R> iterator() {
        return this.localStream.iterator();
    }

    @Override
    public Spliterator<R> spliterator() {
        return this.localStream.spliterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.localStream.toArray(generator);
    }

    @Override
    public CacheStream<R> onClose(Runnable closeHandler) {
        this.remoteStream = (BaseCacheStream)this.remoteStream.onClose(closeHandler);
        return this;
    }

    @Override
    public void close() {
        this.localStream.close();
        this.remoteStream.close();
    }
}

