/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.primitive;

import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.primitive.AbstractForEachLongOperation;

public class ForEachLongOperation<K>
extends AbstractForEachLongOperation<K> {
    private final LongConsumer consumer;

    public ForEachLongOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize, LongConsumer consumer) {
        super(intermediateOperations, supplier, batchSize);
        this.consumer = consumer;
    }

    @Override
    protected void handleArray(long[] array, int size) {
        for (int i = 0; i < size; ++i) {
            this.consumer.accept(array[i]);
        }
    }

    public LongConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void handleInjection(ComponentRegistry registry) {
        super.handleInjection(registry);
        if (this.consumer instanceof CacheAware) {
            ((CacheAware)((Object)this.consumer)).injectCache(registry.getComponent(Cache.class));
        }
    }
}

