/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.TimeService;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class ChannelFactoryTransport
extends JGroupsTransport {
    private final ChannelFactory factory;

    public ChannelFactoryTransport(ChannelFactory factory) {
        this.factory = factory;
    }

    @Inject
    public void initialize(GlobalConfiguration configuration, StreamingMarshaller marshaller, CacheManagerNotifier notifier, TimeService timeService, InboundInvocationHandler globalHandler, @ComponentName(value="org.infinispan.executors.timeout") ScheduledExecutorService timeoutExecutor, @ComponentName(value="org.infinispan.executors.remote") ExecutorService remoteExecutor) {
        super.initialize(configuration, marshaller, notifier, timeService, globalHandler, timeoutExecutor, remoteExecutor);
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        builder.globalJmxStatistics().read(configuration.globalJmxStatistics()).disable();
        TransportConfiguration transport = configuration.transport();
        builder.transport().clusterName(transport.clusterName()).distributedSyncTimeout(transport.distributedSyncTimeout()).initialClusterSize(transport.initialClusterSize()).initialClusterTimeout(transport.initialClusterTimeout(), TimeUnit.MILLISECONDS).machineId(transport.machineId()).nodeName(transport.nodeName()).rackId(transport.rackId()).siteId(transport.siteId()).transport(transport.transport()).withProperties((Properties)transport.properties());
        this.configuration = builder.build();
    }

    protected void initChannel() {
        try {
            this.channel = this.factory.createChannel(this.configuration.globalJmxStatistics().cacheManagerName());
            this.channel.setDiscardOwnMessages(false);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }
}

