/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.NoTransportBuilder;
import org.jboss.as.clustering.infinispan.subsystem.SiteBuilder;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.spi.GroupAliasBuilderProvider;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class NoTransportServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress containerAddress = address.getParent();
        String name = containerAddress.getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        new NoTransportBuilder(address).build(target).install();
        new SiteBuilder(address).build(target).install();
        TransportResourceDefinition.CapabilityServiceNameRegistry registry = new TransportResourceDefinition.CapabilityServiceNameRegistry(address);
        for (GroupAliasBuilderProvider provider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
            for (CapabilityServiceBuilder builder : provider.getBuilders((ServiceNameRegistry)registry, name, "local")) {
                builder.configure(context).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) {
        PathAddress address = context.getCurrentAddress();
        PathAddress containerAddress = address.getParent();
        String name = containerAddress.getLastElement().getValue();
        TransportResourceDefinition.CapabilityServiceNameRegistry registry = new TransportResourceDefinition.CapabilityServiceNameRegistry(address);
        for (GroupAliasBuilderProvider provider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
            for (ServiceNameProvider builder : provider.getBuilders((ServiceNameRegistry)registry, name, "local")) {
                context.removeService(builder.getServiceName());
            }
        }
        EnumSet.allOf(CacheContainerComponent.class).stream().map(component -> component.getServiceName(address)).forEach(serviceName -> context.removeService(serviceName));
    }
}

