/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.more;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Scanner;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.man.FileParser;
import org.aesh.command.man.TerminalPage;
import org.aesh.command.option.Arguments;
import org.aesh.extensions.less.SimpleFileParser;
import org.aesh.io.Resource;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.terminal.Key;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;

@CommandDefinition(name="more", description="is more less?")
public class More
implements Command<CommandInvocation> {
    private int rows;
    private int topVisibleRow;
    private int prevTopVisibleRow;
    private StringBuilder number = new StringBuilder();
    private MorePage page;
    private SimpleFileParser loader;
    private CommandInvocation commandInvocation;
    @Arguments
    private List<Resource> arguments;

    public void setFile(File page) throws IOException {
        this.loader.setFile(page);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(new File(filename));
    }

    public void setInput(String input) {
        this.loader.readPageAsString(input);
    }

    public void setInput(InputStream inputStream, String fileName) {
        this.loader.setFile(inputStream, fileName);
    }

    protected void afterAttach() {
        this.rows = this.commandInvocation.getShell().size().getHeight();
        int columns = this.commandInvocation.getShell().size().getWidth();
        try {
            this.page = new MorePage(this.loader, columns);
            if (this.page.hasData()) {
                this.display(Background.INVERSE);
            }
            this.processOperation();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void afterDetach() {
        this.clearNumber();
        this.prevTopVisibleRow = 0;
        this.topVisibleRow = 0;
        this.page.clear();
        this.loader = new SimpleFileParser();
    }

    public void processOperation() {
        boolean attach = true;
        try {
            while (attach) {
                KeyAction operation = this.commandInvocation.input();
                if (Key.q.equalTo(operation)) {
                    attach = false;
                    continue;
                }
                if (Key.ENTER.equalTo(operation)) {
                    this.topVisibleRow += this.getNumber();
                    if (this.topVisibleRow > this.page.size() - this.rows) {
                        this.topVisibleRow = this.page.size() - this.rows;
                        if (this.topVisibleRow < 0) {
                            this.topVisibleRow = 0;
                        }
                        this.display(Background.INVERSE);
                        attach = false;
                    } else {
                        this.display(Background.INVERSE);
                    }
                    this.clearNumber();
                    continue;
                }
                if (Key.CTRL_F.equalTo(operation) || Key.SPACE.equalTo(operation)) {
                    this.topVisibleRow += this.rows * this.getNumber();
                    if (this.topVisibleRow > this.page.size() - this.rows) {
                        this.topVisibleRow = this.page.size() - this.rows;
                        if (this.topVisibleRow < 0) {
                            this.topVisibleRow = 0;
                        }
                        this.display(Background.INVERSE);
                        attach = false;
                    } else {
                        this.display(Background.INVERSE);
                    }
                    this.clearNumber();
                    continue;
                }
                if (Key.CTRL_B.equalTo(operation)) {
                    this.topVisibleRow -= this.rows * this.getNumber();
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display(Background.INVERSE);
                    this.clearNumber();
                    continue;
                }
                if (!Character.isDigit((char)operation.getCodePointAt(0))) continue;
                this.number.append(Character.getNumericValue(operation.getCodePointAt(0)));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.afterDetach();
    }

    private void display(Background background) {
        this.commandInvocation.getShell().write(ANSI.printAnsi((String)"0G"));
        this.commandInvocation.getShell().write(ANSI.printAnsi((String)"2K"));
        if (this.prevTopVisibleRow == 0 && this.topVisibleRow == 0) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.commandInvocation.getShell().write(this.page.getLine(i));
                this.commandInvocation.getShell().write(Config.getLineSeparator());
            }
        } else if (this.prevTopVisibleRow < this.topVisibleRow) {
            for (int i = this.prevTopVisibleRow; i < this.topVisibleRow; ++i) {
                this.commandInvocation.getShell().write(this.page.getLine(i + this.rows));
                this.commandInvocation.getShell().write(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        } else if (this.prevTopVisibleRow > this.topVisibleRow) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.commandInvocation.getShell().write(this.page.getLine(i));
                this.commandInvocation.getShell().write(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        }
        this.displayBottom(background);
    }

    private void displayBottom(Background background) {
        if (background == Background.INVERSE) {
            this.commandInvocation.getShell().write(ANSI.INVERT_BACKGROUND);
            this.commandInvocation.getShell().write("--More--(");
            this.commandInvocation.getShell().write(this.getPercentDisplayed() + "%)");
            this.commandInvocation.getShell().write(ANSI.NORMAL_BACKGROUND);
        }
    }

    private String getPercentDisplayed() {
        double row = this.topVisibleRow + this.rows;
        if (row > (double)this.page.size()) {
            row = this.page.size();
        }
        return String.valueOf((int)(row / (double)this.page.size() * 100.0));
    }

    public void displayHelp() throws IOException {
        this.commandInvocation.getShell().writeln(Config.getLineSeparator() + "Usage: more [options] file...");
    }

    private int getNumber() {
        if (this.number.length() > 0) {
            return Integer.parseInt(this.number.toString());
        }
        return 1;
    }

    private void clearNumber() {
        this.number = new StringBuilder();
    }

    @Override
    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException {
        this.commandInvocation = commandInvocation;
        this.loader = new SimpleFileParser();
        try {
            if (commandInvocation.getConfiguration().getPipedData() != null && commandInvocation.getConfiguration().getPipedData().available() > 0) {
                Scanner s = new Scanner(commandInvocation.getConfiguration().getPipedData()).useDelimiter("\\A");
                String fileContent = s.hasNext() ? s.next() : "";
                this.setInput(fileContent);
                this.afterAttach();
                return CommandResult.SUCCESS;
            }
        }
        catch (IOException ex) {
            throw new CommandException(ex);
        }
        if (this.arguments != null && this.arguments.size() > 0) {
            Resource f = this.arguments.get(0);
            f = f.resolve(commandInvocation.getAeshContext().getCurrentWorkingDirectory()).get(0);
            try {
                if (f.isLeaf()) {
                    this.setInput(f.read(), f.getName());
                    this.afterAttach();
                } else if (f.isDirectory()) {
                    commandInvocation.getShell().writeln(f.getAbsolutePath() + ": is a directory");
                } else {
                    commandInvocation.getShell().writeln(f.getAbsolutePath() + ": No such file or directory");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return CommandResult.SUCCESS;
    }

    private class MorePage
    extends TerminalPage {
        public MorePage(FileParser fileParser, int columns) throws IOException {
            super(fileParser, columns);
        }
    }

    private static enum Background {
        NORMAL,
        INVERSE;

    }
}

