/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.ArgumentValueConverter;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ResourceCompositeOperationHandler
extends BaseOperationCommand {
    private final String[] ops;
    private final Map<String, Map<String, ArgumentWithValue>> opArgs = new HashMap<String, Map<String, ArgumentWithValue>>();
    protected final String idProperty;
    protected final ArgumentWithValue name;
    protected final ArgumentWithValue profile;
    private Map<String, ArgumentValueConverter> propConverters;
    private Map<String, CommandLineCompleter> valueCompleters;
    private final Map<String, CommandArgument> staticArgs = new HashMap<String, CommandArgument>();
    private Map<String, CommandArgument> allArgs;

    public ResourceCompositeOperationHandler(CommandContext ctx, String command, String nodeType, String idProperty, String ... operations) {
        super(ctx, command, true);
        if (command == null) {
            throw new IllegalArgumentException("Command name can't be null.");
        }
        if (operations == null || operations.length == 0) {
            throw new IllegalArgumentException("There must be at least one operation.");
        }
        this.ops = operations;
        this.idProperty = idProperty;
        this.addRequiredPath(nodeType);
        this.profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), "--profile"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ResourceCompositeOperationHandler.this.isDependsOnProfile()) {
                    return false;
                }
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.name = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
                if (ResourceCompositeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                    String profileName = ResourceCompositeOperationHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    if (ResourceCompositeOperationHandler.this.profile == null) {
                        return Collections.emptyList();
                    }
                    address.toNode("profile", profileName);
                }
                for (OperationRequestAddress.Node node : ResourceCompositeOperationHandler.this.getRequiredAddress()) {
                    address.toNode(node.getType(), node.getName());
                }
                return Util.getNodeNames(ctx.getModelControllerClient(), address, ResourceCompositeOperationHandler.this.getRequiredType());
            }
        }), idProperty == null ? "--name" : "--" + idProperty){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ResourceCompositeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode() && !ResourceCompositeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.name.addCantAppearAfter(this.helpArg);
        this.helpArg.addCantAppearAfter(this.name);
        this.staticArgs.put(this.helpArg.getFullName(), this.helpArg);
        this.staticArgs.put(this.profile.getFullName(), this.profile);
        this.staticArgs.put(this.name.getFullName(), this.name);
        AccessRequirementBuilder.RequirementSetBuilder reqBuilder = AccessRequirementBuilder.Factory.create(ctx).any();
        AccessRequirementBuilder.RequirementSetBuilder domainReq = this.isDependsOnProfile() ? reqBuilder.domain().all() : null;
        AccessRequirementBuilder.RequirementSetBuilder standaloneReq = reqBuilder.standalone().all();
        for (String op : this.ops) {
            if (domainReq != null) {
                domainReq.profileOperation(nodeType + "=?", op);
            }
            standaloneReq.operation(nodeType + "=?", op);
        }
        this.accessRequirement = reqBuilder.build();
    }

    public void addValueConverter(String propertyName, ArgumentValueConverter converter) {
        if (this.propConverters == null) {
            this.propConverters = new HashMap<String, ArgumentValueConverter>();
        }
        this.propConverters.put(propertyName, converter);
    }

    public void addValueCompleter(String propertyName, CommandLineCompleter completer) {
        if (this.valueCompleters == null) {
            this.valueCompleters = new HashMap<String, CommandLineCompleter>();
        }
        this.valueCompleters.put(propertyName, completer);
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ModelNode address = this.buildOperationAddress(ctx);
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        for (String opName : this.ops) {
            Map<String, ArgumentWithValue> opArgs;
            ModelNode req = new ModelNode();
            req.get("operation").set(opName);
            req.get("address").set(address);
            try {
                opArgs = this.getOperationArguments(ctx, opName);
            }
            catch (CommandFormatException e) {
                throw e;
            }
            catch (CommandLineException e) {
                throw new CommandFormatException("Failed to read " + opName + " arguments.", e);
            }
            for (ArgumentWithValue arg : opArgs.values()) {
                String argName = arg.getFullName();
                String propName = argName.charAt(1) == '-' ? argName.substring(2) : argName.substring(1);
                ModelNode nodeValue = arg.toModelNode(ctx);
                if (nodeValue == null) continue;
                req.get(propName).set(nodeValue);
            }
            steps.add(req);
        }
        return composite;
    }

    protected ModelNode buildOperationAddress(CommandContext ctx) throws CommandFormatException {
        String name = this.name.getValue(ctx.getParsedCommandLine(), true);
        ModelNode address = new ModelNode();
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            String profile = this.profile.getValue(ctx.getParsedCommandLine());
            if (profile == null) {
                throw new OperationFormatException("Required argument --profile is missing.");
            }
            address.add("profile", profile);
        }
        for (OperationRequestAddress.Node node : this.getRequiredAddress()) {
            address.add(node.getType(), node.getName());
        }
        address.add(this.getRequiredType(), name);
        return address;
    }

    @Override
    public CommandArgument getArgument(CommandContext ctx, String name) {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        try {
            if (!this.name.isValueComplete(args)) {
                return this.staticArgs.get(name);
            }
        }
        catch (CommandFormatException e) {
            return null;
        }
        return this.getAllArguments(ctx).get(name);
    }

    @Override
    public Collection<CommandArgument> getArguments(CommandContext ctx) {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        try {
            if (!this.name.isValueComplete(args)) {
                return this.staticArgs.values();
            }
        }
        catch (CommandFormatException e) {
            return null;
        }
        return this.getAllArguments(ctx).values();
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        Map<String, CommandArgument> allArgs = this.getAllArguments(ctx);
        if (!allArgs.keySet().containsAll(ctx.getParsedCommandLine().getPropertyNames())) {
            HashSet<String> unrecognized = new HashSet<String>(ctx.getParsedCommandLine().getPropertyNames());
            unrecognized.removeAll(allArgs.keySet());
            throw new CommandFormatException("Unrecognized arguments: " + unrecognized);
        }
    }

    protected Map<String, CommandArgument> getAllArguments(CommandContext ctx) {
        if (this.allArgs == null) {
            this.allArgs = this.loadArguments(ctx);
            this.allArgs.putAll(this.staticArgs);
        }
        return this.allArgs;
    }

    protected Map<String, CommandArgument> loadArguments(CommandContext ctx) {
        HashMap<String, CommandArgument> allArgs = new HashMap<String, CommandArgument>();
        for (String opName : this.ops) {
            try {
                allArgs.putAll(this.getOperationArguments(ctx, opName));
            }
            catch (CommandLineException e) {
                return Collections.emptyMap();
            }
        }
        return allArgs;
    }

    protected Map<String, ArgumentWithValue> getOperationArguments(CommandContext ctx, String opName) throws CommandLineException {
        Map<String, ArgumentWithValue> args = this.opArgs.get(opName);
        if (args != null) {
            return args;
        }
        ModelNode descr = this.getOperationDescription(ctx, opName);
        if (descr.has("request-properties")) {
            args = new HashMap<String, ArgumentWithValue>();
            List<Property> propList = descr.get("request-properties").asPropertyList();
            for (Property prop : propList) {
                CommandLineCompleter valueCompleter = null;
                ArgumentValueConverter valueConverter = null;
                if (this.propConverters != null) {
                    valueConverter = this.propConverters.get(prop.getName());
                }
                if (this.valueCompleters != null) {
                    valueCompleter = this.valueCompleters.get(prop.getName());
                }
                if (valueConverter == null) {
                    valueConverter = ArgumentValueConverter.DEFAULT;
                    ModelType propType = this.getType(prop.getValue());
                    if (propType != null) {
                        if (ModelType.BOOLEAN == propType) {
                            if (valueCompleter == null) {
                                valueCompleter = SimpleTabCompleter.BOOLEAN;
                            }
                        } else if (ModelType.STRING == propType) {
                            valueConverter = ArgumentValueConverter.NON_OBJECT;
                        } else if (prop.getName().endsWith("properties")) {
                            valueConverter = ArgumentValueConverter.PROPERTIES;
                        } else if (ModelType.LIST == propType) {
                            valueConverter = this.asType(descr.get("value-type")) == ModelType.PROPERTY ? ArgumentValueConverter.PROPERTIES : ArgumentValueConverter.LIST;
                        }
                    }
                }
                ArgumentWithValue arg = new ArgumentWithValue((CommandHandlerWithArguments)this, valueCompleter, valueConverter, "--" + prop.getName());
                args.put(arg.getFullName(), arg);
            }
        } else {
            args = Collections.emptyMap();
        }
        this.opArgs.put(opName, args);
        return args;
    }

    protected ModelNode getOperationDescription(CommandContext ctx, String operationName) throws CommandLineException {
        ModelNode result;
        ModelNode request = this.initRequest(ctx);
        request.get("operation").set("read-operation-description");
        request.get("name").set(operationName);
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to execute read-operation-description.", e);
        }
        if (!result.hasDefined("result")) {
            throw new CommandLineException("Operation description received no result.");
        }
        return result.get("result");
    }

    protected ModelNode initRequest(CommandContext ctx) throws CommandLineException {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            String profileName = this.profile.getValue(ctx.getParsedCommandLine());
            if (profileName == null) {
                throw new CommandLineException("WARNING: --profile argument is required for the complete description.");
            }
            address.add("profile", profileName);
        }
        for (OperationRequestAddress.Node node : this.getRequiredAddress()) {
            address.add(node.getType(), node.getName());
        }
        address.add(this.getRequiredType(), "?");
        return request;
    }

    protected ModelType getType(ModelNode descr) {
        if (!descr.has("type")) {
            return null;
        }
        try {
            return descr.get("type").asType();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    protected ModelType asType(ModelNode type) {
        if (type == null) {
            return null;
        }
        try {
            return type.asType();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

