/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import javax.crypto.Mac;
import org.wildfly.common.Assert;
import org.wildfly.security.util.Alphabet;
import org.wildfly.security.util.ByteStringBuilder;
import org.wildfly.security.util.CodePointIterator;
import org.wildfly.security.util.NumericIterator;

public abstract class ByteIterator
extends NumericIterator {
    private static final int OP_BUFFER_SIZE = 8192;
    private static final ThreadLocal<byte[]> OP_BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[8192];
        }
    };
    private static final byte[] NO_BYTES = new byte[0];
    public static final ByteIterator EMPTY = new ByteIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrev() {
            return false;
        }

        @Override
        public int next() {
            throw new NoSuchElementException();
        }

        @Override
        public int peekNext() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public int prev() {
            throw new NoSuchElementException();
        }

        @Override
        public int peekPrev() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public int offset() {
            return 0;
        }

        @Override
        public byte[] drain() {
            return NO_BYTES;
        }

        @Override
        public int drain(byte[] dst, int offs, int len) {
            return 0;
        }
    };

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract boolean hasPrev();

    @Override
    public abstract int next() throws NoSuchElementException;

    @Override
    public abstract int peekNext() throws NoSuchElementException;

    @Override
    public abstract int prev() throws NoSuchElementException;

    @Override
    public abstract int peekPrev() throws NoSuchElementException;

    public abstract int offset();

    public int getBE16() throws NoSuchElementException {
        return this.next() << 8 | this.next();
    }

    public int getBE32() throws NoSuchElementException {
        return this.next() << 24 | this.next() << 16 | this.next() << 8 | this.next();
    }

    public long getBE64() throws NoSuchElementException {
        return (long)this.next() << 56 | (long)this.next() << 48 | (long)this.next() << 40 | (long)this.next() << 32 | (long)this.next() << 24 | (long)this.next() << 16 | (long)this.next() << 8 | (long)this.next();
    }

    public int getPackedBE32() throws NoSuchElementException {
        int v = this.next();
        int t = 0;
        while ((v & 0x80) != 0) {
            t = t << 7 | v & 0x7F;
            v = this.next();
        }
        t = t << 7 | v;
        return t;
    }

    public long getPackedBE64() throws NoSuchElementException {
        int v = this.next();
        long t = 0L;
        while ((v & 0x80) != 0) {
            t = t << 7 | (long)(v & 0x7F);
            v = this.next();
        }
        t = t << 7 | (long)v;
        return t;
    }

    public ByteStringBuilder appendTo(ByteStringBuilder builder) {
        byte[] buffer = OP_BUFFER.get();
        int cnt = this.drain(buffer);
        while (cnt > 0) {
            builder.append(buffer, 0, cnt);
            cnt = this.drain(buffer);
        }
        return builder;
    }

    public void update(MessageDigest digest) throws IllegalStateException {
        byte[] buffer = OP_BUFFER.get();
        int cnt = this.drain(buffer);
        while (cnt > 0) {
            digest.update(buffer, 0, cnt);
            cnt = this.drain(buffer);
        }
    }

    public ByteIterator doFinal(MessageDigest digest) throws IllegalStateException {
        this.update(digest);
        return ByteIterator.ofBytes(digest.digest());
    }

    public void update(Mac mac) throws IllegalStateException {
        byte[] buffer = OP_BUFFER.get();
        int cnt = this.drain(buffer);
        while (cnt > 0) {
            mac.update(buffer, 0, cnt);
            cnt = this.drain(buffer);
        }
    }

    public ByteIterator doFinal(Mac mac) throws IllegalStateException {
        return ByteIterator.ofBytes(mac.doFinal(this.drain()));
    }

    public void update(Signature signature) throws IllegalStateException {
        byte[] buffer = OP_BUFFER.get();
        try {
            int cnt = this.drain(buffer);
            while (cnt > 0) {
                signature.update(buffer, 0, cnt);
                cnt = this.drain(buffer);
            }
            signature.update(this.drain());
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    public ByteIterator sign(Signature signature) throws IllegalStateException {
        this.update(signature);
        try {
            return ByteIterator.ofBytes(signature.sign());
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean verify(Signature signature) throws IllegalStateException {
        byte[] buffer = OP_BUFFER.get();
        try {
            int cnt = this.drain(buffer);
            while (cnt > 0) {
                signature.update(buffer, 0, cnt);
                cnt = this.drain(buffer);
            }
            return signature.verify(NO_BYTES);
        }
        catch (SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ByteIterator base64Decode(Alphabet.Base64Alphabet alphabet, boolean requirePadding) {
        return super.base64Decode(alphabet, requirePadding);
    }

    public ByteIterator base64Decode(Alphabet.Base64Alphabet alphabet) {
        return super.base64Decode(alphabet, true);
    }

    public ByteIterator base64Decode() {
        return super.base64Decode(Alphabet.Base64Alphabet.STANDARD, true);
    }

    public CodePointIterator base64Encode(final Alphabet.Base64Alphabet alphabet, boolean addPadding) {
        if (alphabet.littleEndian) {
            return new Base64EncodingCodePointIterator(addPadding){

                @Override
                int calc0(int b0) {
                    return alphabet.encode(b0 & 0x3F);
                }

                @Override
                int calc1(int b0, int b1) {
                    return alphabet.encode((b1 << 2 | b0 >> 6) & 0x3F);
                }

                @Override
                int calc2(int b1, int b2) {
                    return alphabet.encode((b2 << 4 | b1 >> 4) & 0x3F);
                }

                @Override
                int calc3(int b2) {
                    return alphabet.encode(b2 >> 2 & 0x3F);
                }
            };
        }
        return new Base64EncodingCodePointIterator(addPadding){

            @Override
            int calc0(int b0) {
                return alphabet.encode(b0 >> 2 & 0x3F);
            }

            @Override
            int calc1(int b0, int b1) {
                return alphabet.encode((b0 << 4 | b1 >> 4) & 0x3F);
            }

            @Override
            int calc2(int b1, int b2) {
                return alphabet.encode((b1 << 2 | b2 >> 6) & 0x3F);
            }

            @Override
            int calc3(int b2) {
                return alphabet.encode(b2 & 0x3F);
            }
        };
    }

    public CodePointIterator base64Encode(Alphabet.Base64Alphabet alphabet) {
        return this.base64Encode(alphabet, true);
    }

    public CodePointIterator base64Encode() {
        return this.base64Encode(Alphabet.Base64Alphabet.STANDARD, true);
    }

    @Override
    public ByteIterator base32Decode(Alphabet.Base32Alphabet alphabet, boolean requirePadding) {
        return super.base32Decode(alphabet, requirePadding);
    }

    public ByteIterator base32Decode(Alphabet.Base32Alphabet alphabet) {
        return super.base32Decode(alphabet, true);
    }

    public ByteIterator base32Decode() {
        return super.base32Decode(Alphabet.Base32Alphabet.STANDARD, true);
    }

    public CodePointIterator base32Encode(final Alphabet.Base32Alphabet alphabet, boolean addPadding) {
        if (alphabet.littleEndian) {
            return new Base32EncodingCodePointIterator(addPadding){

                @Override
                int calc0(int b0) {
                    return alphabet.encode(b0 & 0x1F);
                }

                @Override
                int calc1(int b0, int b1) {
                    return alphabet.encode((b1 << 3 | b0 >> 5) & 0x1F);
                }

                @Override
                int calc2(int b1) {
                    return alphabet.encode(b1 >> 2 & 0x1F);
                }

                @Override
                int calc3(int b1, int b2) {
                    return alphabet.encode((b2 << 1 | b1 >> 7) & 0x1F);
                }

                @Override
                int calc4(int b2, int b3) {
                    return alphabet.encode((b3 << 4 | b2 >> 4) & 0x1F);
                }

                @Override
                int calc5(int b3) {
                    return alphabet.encode(b3 >> 1 & 0x1F);
                }

                @Override
                int calc6(int b3, int b4) {
                    return alphabet.encode((b4 << 2 | b3 >> 6) & 0x1F);
                }

                @Override
                int calc7(int b4) {
                    return alphabet.encode(b4 >> 3 & 0x1F);
                }
            };
        }
        return new Base32EncodingCodePointIterator(addPadding){

            @Override
            int calc0(int b0) {
                return alphabet.encode(b0 >> 3 & 0x1F);
            }

            @Override
            int calc1(int b0, int b1) {
                return alphabet.encode((b0 << 2 | b1 >> 6) & 0x1F);
            }

            @Override
            int calc2(int b1) {
                return alphabet.encode(b1 >> 1 & 0x1F);
            }

            @Override
            int calc3(int b1, int b2) {
                return alphabet.encode((b1 << 4 | b2 >> 4) & 0x1F);
            }

            @Override
            int calc4(int b2, int b3) {
                return alphabet.encode((b2 << 1 | b3 >> 7) & 0x1F);
            }

            @Override
            int calc5(int b3) {
                return alphabet.encode(b3 >> 2 & 0x1F);
            }

            @Override
            int calc6(int b3, int b4) {
                return alphabet.encode((b3 << 3 | b4 >> 5) & 0x1F);
            }

            @Override
            int calc7(int b4) {
                return alphabet.encode(b4 & 0x1F);
            }
        };
    }

    public CodePointIterator base32Encode(Alphabet.Base32Alphabet alphabet) {
        return this.base32Encode(alphabet, true);
    }

    public CodePointIterator base32Encode() {
        return this.base32Encode(Alphabet.Base32Alphabet.STANDARD, true);
    }

    @Override
    public ByteIterator hexDecode() {
        return super.hexDecode();
    }

    public CodePointIterator hexEncode(final boolean toUpperCase) {
        return new CodePointIterator(){
            int b;
            boolean lo;

            @Override
            public boolean hasNext() {
                return this.lo || ByteIterator.this.hasNext();
            }

            @Override
            public boolean hasPrev() {
                return this.lo || ByteIterator.this.hasPrev();
            }

            private int hex(int i) {
                if (i < 10) {
                    return 48 + i;
                }
                assert (i < 16);
                return (toUpperCase ? 65 : 97) + i - 10;
            }

            @Override
            public int next() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.lo) {
                    this.lo = false;
                    return this.hex(this.b & 0xF);
                }
                this.b = ByteIterator.this.next();
                this.lo = true;
                return this.hex(this.b >> 4);
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.lo) {
                    return this.hex(this.b & 0xF);
                }
                return this.hex(ByteIterator.this.peekNext() >> 4);
            }

            @Override
            public int prev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                if (this.lo) {
                    this.lo = false;
                    ByteIterator.this.prev();
                    return this.hex(this.b >> 4);
                }
                this.b = ByteIterator.this.peekPrev();
                this.lo = true;
                return this.hex(this.b & 0xF);
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                if (this.lo) {
                    return this.hex(this.b >> 4);
                }
                return this.hex(ByteIterator.this.peekPrev() & 0xF);
            }

            @Override
            public int offset() {
                return ByteIterator.this.offset() * 2 + (this.lo ? 1 : 0);
            }
        };
    }

    public CodePointIterator hexEncode() {
        return this.hexEncode(false);
    }

    public CodePointIterator asUtf8String() {
        if (!this.hasNext()) {
            return CodePointIterator.EMPTY;
        }
        return new CodePointIterator(){
            private int offset = 0;

            @Override
            public boolean hasNext() {
                return ByteIterator.this.hasNext();
            }

            @Override
            public boolean hasPrev() {
                return this.offset > 0;
            }

            private void seekToNext() {
                while (ByteIterator.this.hasNext()) {
                    int b = ByteIterator.this.next();
                    if ((b & 0xC0) == 128) continue;
                    ByteIterator.this.prev();
                    return;
                }
            }

            private void seekToPrev() {
                while (ByteIterator.this.hasPrev()) {
                    int b = ByteIterator.this.prev();
                    if ((b & 0xC0) == 128) continue;
                    return;
                }
            }

            @Override
            public int next() {
                if (!ByteIterator.this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.offset;
                int a = ByteIterator.this.next();
                if ((a & 0x80) == 0) {
                    return a;
                }
                if ((a & 0xC0) == 128) {
                    this.seekToNext();
                    return 65533;
                }
                if (!ByteIterator.this.hasNext()) {
                    return 65533;
                }
                int b = ByteIterator.this.next();
                if ((b & 0xC0) != 128) {
                    this.seekToNext();
                    return 65533;
                }
                if ((a & 0xE0) == 192) {
                    return (a & 0x1F) << 6 | b & 0x3F;
                }
                if (!ByteIterator.this.hasNext()) {
                    return 65533;
                }
                int c = ByteIterator.this.next();
                if ((c & 0xC0) != 128) {
                    this.seekToNext();
                    return 65533;
                }
                if ((a & 0xF0) == 224) {
                    return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
                }
                if (!ByteIterator.this.hasNext()) {
                    return 65533;
                }
                int d = ByteIterator.this.next();
                if ((d & 0xC0) != 128) {
                    this.seekToNext();
                    return 65533;
                }
                if ((a & 0xF8) == 240) {
                    return (a & 7) << 18 | (b & 0x3F) << 12 | (c & 0x3F) << 6 | d & 0x3F;
                }
                this.seekToNext();
                return 65533;
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!ByteIterator.this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int a = ByteIterator.this.peekNext();
                if ((a & 0x80) == 0) {
                    return a;
                }
                if ((a & 0xC0) == 128) {
                    return 65533;
                }
                ByteIterator.this.next();
                if (!ByteIterator.this.hasNext()) {
                    ByteIterator.this.prev();
                    return 65533;
                }
                int b = ByteIterator.this.peekNext();
                if ((b & 0xC0) != 128) {
                    ByteIterator.this.prev();
                    return 65533;
                }
                if ((a & 0xE0) == 192) {
                    ByteIterator.this.prev();
                    return (a & 0x1F) << 6 | b & 0x3F;
                }
                ByteIterator.this.next();
                if (!ByteIterator.this.hasNext()) {
                    ByteIterator.this.prev();
                    ByteIterator.this.prev();
                    return 65533;
                }
                int c = ByteIterator.this.peekNext();
                if ((c & 0xC0) != 128) {
                    ByteIterator.this.prev();
                    ByteIterator.this.prev();
                    return 65533;
                }
                if ((a & 0xF0) == 224) {
                    ByteIterator.this.prev();
                    ByteIterator.this.prev();
                    return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
                }
                ByteIterator.this.next();
                if (!ByteIterator.this.hasNext()) {
                    ByteIterator.this.prev();
                    ByteIterator.this.prev();
                    ByteIterator.this.prev();
                    return 65533;
                }
                int d = ByteIterator.this.peekNext();
                if ((d & 0xC0) != 128) {
                    ByteIterator.this.prev();
                    ByteIterator.this.prev();
                    ByteIterator.this.prev();
                    return 65533;
                }
                if ((a & 0xF8) == 240) {
                    ByteIterator.this.prev();
                    ByteIterator.this.prev();
                    ByteIterator.this.prev();
                    return (a & 7) << 18 | (b & 0x3F) << 12 | (c & 0x3F) << 6 | d & 0x3F;
                }
                ByteIterator.this.prev();
                ByteIterator.this.prev();
                ByteIterator.this.prev();
                return 65533;
            }

            @Override
            public int prev() {
                if (!ByteIterator.this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                --this.offset;
                int a = ByteIterator.this.prev();
                if ((a & 0x80) == 0) {
                    return a;
                }
                if ((a & 0xC0) != 128) {
                    this.seekToPrev();
                    return 65533;
                }
                int cp = a & 0x3F;
                a = ByteIterator.this.prev();
                if ((a & 0xE0) == 192) {
                    return (a & 0x1F) << 6 | cp;
                }
                if ((a & 0xC0) != 128) {
                    this.seekToPrev();
                    return 65533;
                }
                cp |= (a & 0x3F) << 6;
                a = ByteIterator.this.prev();
                if ((a & 0xF0) == 224) {
                    return (a & 0xF) << 12 | cp;
                }
                if ((a & 0xC0) != 128) {
                    this.seekToPrev();
                    return 65533;
                }
                cp |= (a & 0x3F) << 12;
                a = ByteIterator.this.prev();
                if ((a & 0xF8) == 240) {
                    return (a & 7) << 18 | cp;
                }
                this.seekToPrev();
                return 65533;
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!ByteIterator.this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                int a = ByteIterator.this.peekPrev();
                if ((a & 0x80) == 0) {
                    return a;
                }
                if ((a & 0xC0) != 128) {
                    return 65533;
                }
                int cp = a & 0x3F;
                ByteIterator.this.prev();
                a = ByteIterator.this.peekPrev();
                if ((a & 0xE0) == 192) {
                    ByteIterator.this.next();
                    return (a & 0x1F) << 6 | cp;
                }
                if ((a & 0xC0) != 128) {
                    ByteIterator.this.next();
                    return 65533;
                }
                cp |= (a & 0x3F) << 6;
                ByteIterator.this.prev();
                a = ByteIterator.this.peekPrev();
                if ((a & 0xF0) == 224) {
                    ByteIterator.this.next();
                    ByteIterator.this.next();
                    return (a & 0xF) << 12 | cp;
                }
                if ((a & 0xC0) != 128) {
                    ByteIterator.this.next();
                    ByteIterator.this.next();
                    return 65533;
                }
                cp |= (a & 0x3F) << 12;
                ByteIterator.this.prev();
                a = ByteIterator.this.peekPrev();
                if ((a & 0xF8) == 240) {
                    ByteIterator.this.next();
                    ByteIterator.this.next();
                    ByteIterator.this.next();
                    return (a & 7) << 18 | cp;
                }
                ByteIterator.this.next();
                ByteIterator.this.next();
                ByteIterator.this.next();
                return 65533;
            }

            @Override
            public int offset() {
                return this.offset;
            }
        };
    }

    public CodePointIterator asLatin1String() {
        if (!this.hasNext()) {
            return CodePointIterator.EMPTY;
        }
        final int offset = this.offset();
        return new CodePointIterator(){

            @Override
            public boolean hasNext() {
                return ByteIterator.this.hasNext();
            }

            @Override
            public boolean hasPrev() {
                return offset > 0 && ByteIterator.this.hasPrev();
            }

            @Override
            public int next() {
                return ByteIterator.this.next();
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                return ByteIterator.this.peekNext();
            }

            @Override
            public int prev() {
                if (offset == 0) {
                    throw new NoSuchElementException();
                }
                return ByteIterator.this.prev();
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                return ByteIterator.this.peekPrev();
            }

            @Override
            public int offset() {
                return ByteIterator.this.offset() - offset;
            }
        };
    }

    public final boolean contentEquals(ByteIterator other) {
        while (this.hasNext()) {
            if (!other.hasNext()) {
                return false;
            }
            if (this.next() == other.next()) continue;
            return false;
        }
        return !other.hasNext();
    }

    public final ByteIterator limitedTo(final int size) {
        if (size <= 0 || !this.hasNext()) {
            return EMPTY;
        }
        return new ByteIterator(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < size && ByteIterator.this.hasNext();
            }

            @Override
            public boolean hasPrev() {
                return this.offset > 0;
            }

            @Override
            public int next() {
                if (this.offset == size) {
                    throw new NoSuchElementException();
                }
                ++this.offset;
                return ByteIterator.this.next();
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (this.offset == size) {
                    throw new NoSuchElementException();
                }
                return ByteIterator.this.peekNext();
            }

            @Override
            public int prev() {
                if (this.offset == 0) {
                    throw new NoSuchElementException();
                }
                --this.offset;
                return ByteIterator.this.prev();
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (this.offset == 0) {
                    throw new NoSuchElementException();
                }
                return ByteIterator.this.peekPrev();
            }

            @Override
            public int drain(byte[] dst, int offs, int len) {
                return super.drain(dst, offs, Math.min(len, size - this.offset));
            }

            @Override
            public int offset() {
                return this.offset;
            }
        };
    }

    public final ByteIterator delimitedBy(final int ... delims) {
        if (delims == null || delims.length == 0 || !this.hasNext()) {
            return EMPTY;
        }
        for (int delim : delims) {
            if (delim >= 0 && delim <= 255) continue;
            return EMPTY;
        }
        return new ByteIterator(){
            int offset = 0;
            int current = -1;

            @Override
            public boolean hasNext() {
                return ByteIterator.this.hasNext() && !this.isDelim(ByteIterator.this.peekNext());
            }

            @Override
            public boolean hasPrev() {
                return this.offset > 0;
            }

            @Override
            public int next() {
                int n = ByteIterator.this.peekNext();
                if (this.isDelim(n)) {
                    this.current = -1;
                    throw new NoSuchElementException();
                }
                ++this.offset;
                this.current = ByteIterator.this.next();
                return this.current;
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                int n = ByteIterator.this.peekNext();
                if (this.isDelim(n)) {
                    throw new NoSuchElementException();
                }
                return n;
            }

            @Override
            public int prev() {
                if (this.offset == 0) {
                    this.current = -1;
                    throw new NoSuchElementException();
                }
                --this.offset;
                this.current = ByteIterator.this.prev();
                return this.current;
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (this.offset == 0) {
                    throw new NoSuchElementException();
                }
                return ByteIterator.this.peekPrev();
            }

            @Override
            public int offset() {
                return this.offset;
            }

            private boolean isDelim(int b) {
                for (int delim : delims) {
                    if (delim != b) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public ByteIterator interleavedWith(final byte[] table) {
        return new ByteIterator(){

            @Override
            public boolean hasNext() {
                return ByteIterator.this.hasNext();
            }

            @Override
            public boolean hasPrev() {
                return ByteIterator.this.hasPrev();
            }

            @Override
            public int next() throws NoSuchElementException {
                return table[ByteIterator.this.next()] & 0xFF;
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                return table[ByteIterator.this.peekNext()] & 0xFF;
            }

            @Override
            public int prev() throws NoSuchElementException {
                return table[ByteIterator.this.prev()] & 0xFF;
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                return table[ByteIterator.this.peekPrev()] & 0xFF;
            }

            @Override
            public int offset() {
                return ByteIterator.this.offset();
            }
        };
    }

    public ByteIterator interleavedWith(final int[] table) {
        return new ByteIterator(){

            @Override
            public boolean hasNext() {
                return ByteIterator.this.hasNext();
            }

            @Override
            public boolean hasPrev() {
                return ByteIterator.this.hasPrev();
            }

            @Override
            public int next() throws NoSuchElementException {
                return table[ByteIterator.this.next()] & 0xFF;
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                return table[ByteIterator.this.peekNext()] & 0xFF;
            }

            @Override
            public int prev() throws NoSuchElementException {
                return table[ByteIterator.this.prev()] & 0xFF;
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                return table[ByteIterator.this.peekPrev()] & 0xFF;
            }

            @Override
            public int offset() {
                return ByteIterator.this.offset();
            }
        };
    }

    public ByteArrayOutputStream drainTo(ByteArrayOutputStream stream) {
        while (this.hasNext()) {
            stream.write(this.next());
        }
        return stream;
    }

    public byte[] drain() {
        return this.drainTo(new ByteArrayOutputStream()).toByteArray();
    }

    public byte[] drain(int count) {
        if (count == 0) {
            return NO_BYTES;
        }
        byte[] b = new byte[count];
        int cnt = this.drain(b);
        return cnt == 0 ? NO_BYTES : (cnt < b.length ? Arrays.copyOf(b, cnt) : b);
    }

    public byte[] drainAll(int count) throws NoSuchElementException {
        if (count == 0) {
            return NO_BYTES;
        }
        byte[] b = new byte[count];
        int cnt = this.drain(b);
        if (cnt < b.length) {
            throw new NoSuchElementException();
        }
        return b;
    }

    public int drain(byte[] dst) {
        return this.drain(dst, 0, dst.length);
    }

    public int drain(byte[] dst, int offs, int len) {
        for (int i = 0; i < len; ++i) {
            if (!this.hasNext()) {
                return i;
            }
            dst[offs + i] = (byte)this.next();
        }
        return len;
    }

    public String drainToUtf8(int count) {
        return new String(this.drain(count), StandardCharsets.UTF_8);
    }

    public String drainToLatin1(int count) {
        return new String(this.drain(count), StandardCharsets.ISO_8859_1);
    }

    public static ByteIterator ofBytes(byte ... bytes) {
        return ByteIterator.ofBytes(bytes, 0, bytes.length);
    }

    public static ByteIterator ofBytes(final byte[] bytes, final int offs, final int len) {
        if (len <= 0) {
            return EMPTY;
        }
        return new ByteIterator(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < len;
            }

            @Override
            public boolean hasPrev() {
                return this.idx > 0;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return bytes[offs + this.idx++] & 0xFF;
            }

            @Override
            public int prev() {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                return bytes[offs + --this.idx] & 0xFF;
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return bytes[offs + this.idx] & 0xFF;
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                return bytes[offs + this.idx - 1] & 0xFF;
            }

            @Override
            public int offset() {
                return this.idx;
            }

            @Override
            public void update(MessageDigest digest) throws IllegalStateException {
                digest.update(bytes, offs + this.idx, len - this.idx);
                this.idx = len;
            }

            @Override
            public ByteIterator doFinal(MessageDigest digest) throws IllegalStateException {
                this.update(digest);
                return ByteIterator.ofBytes(digest.digest());
            }

            @Override
            public void update(Mac mac) throws IllegalStateException {
                mac.update(bytes, offs + this.idx, len - this.idx);
                this.idx = len;
            }

            @Override
            public ByteIterator doFinal(Mac mac) throws IllegalStateException {
                this.update(mac);
                return ByteIterator.ofBytes(mac.doFinal());
            }

            @Override
            public void update(Signature signature) throws IllegalStateException {
                try {
                    signature.update(bytes, offs + this.idx, len - this.idx);
                    this.idx = len;
                }
                catch (SignatureException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public boolean verify(Signature signature) throws IllegalStateException {
                try {
                    boolean bl = signature.verify(bytes, offs + this.idx, len - this.idx);
                    return bl;
                }
                catch (SignatureException e) {
                    throw new IllegalStateException(e);
                }
                finally {
                    this.idx = len;
                }
            }

            @Override
            public ByteArrayOutputStream drainTo(ByteArrayOutputStream stream) {
                stream.write(bytes, offs + this.idx, len - this.idx);
                this.idx = len;
                return stream;
            }

            @Override
            public byte[] drain() {
                try {
                    byte[] byArray = Arrays.copyOfRange(bytes, offs + this.idx, offs + len);
                    return byArray;
                }
                finally {
                    this.idx = len;
                }
            }

            @Override
            public int drain(byte[] dst, int offs2, int dlen) {
                int cnt = Math.min(len - this.idx, dlen);
                System.arraycopy(bytes, offs2 + this.idx, dst, offs2, cnt);
                this.idx += cnt;
                return cnt;
            }

            @Override
            public String drainToUtf8(int count) {
                int cnt = Math.min(len - this.idx, count);
                String s = new String(bytes, this.idx, cnt, StandardCharsets.UTF_8);
                this.idx += cnt;
                return s;
            }

            @Override
            public String drainToLatin1(int count) {
                int cnt = Math.min(len - this.idx, count);
                String s = new String(bytes, this.idx, cnt, StandardCharsets.ISO_8859_1);
                this.idx += cnt;
                return s;
            }

            @Override
            public ByteStringBuilder appendTo(ByteStringBuilder builder) {
                builder.append(bytes, offs + this.idx, len - this.idx);
                this.idx = len;
                return builder;
            }
        };
    }

    public static ByteIterator ofBytes(final byte[] bytes, final int offs, final int len, final int[] interleave) {
        if (len <= 0) {
            return EMPTY;
        }
        return new ByteIterator(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < len;
            }

            @Override
            public boolean hasPrev() {
                return this.idx > 0;
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return bytes[offs + interleave[this.idx++]] & 0xFF;
            }

            @Override
            public int prev() {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                return bytes[offs + interleave[--this.idx]] & 0xFF;
            }

            @Override
            public int peekNext() throws NoSuchElementException {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return bytes[offs + interleave[this.idx]] & 0xFF;
            }

            @Override
            public int peekPrev() throws NoSuchElementException {
                if (!this.hasPrev()) {
                    throw new NoSuchElementException();
                }
                return bytes[offs + interleave[this.idx - 1]] & 0xFF;
            }

            @Override
            public int offset() {
                return this.idx;
            }
        };
    }

    public static ByteIterator ofBytes(byte[] bytes, int[] interleave) {
        return ByteIterator.ofBytes(bytes, 0, bytes.length, interleave);
    }

    public final InputStream asInputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return ByteIterator.this.hasNext() ? ByteIterator.this.next() : -1;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int result = ByteIterator.this.drain(b);
                return result == 0 ? (b.length == 0 ? 0 : -1) : result;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int result = ByteIterator.this.drain(b, off, len);
                return result == 0 ? (len == 0 ? 0 : -1) : result;
            }
        };
    }

    abstract class Base32EncodingCodePointIterator
    extends CodePointIterator {
        private final boolean addPadding;
        private int c0;
        private int c1;
        private int c2;
        private int c3;
        private int c4;
        private int c5;
        private int c6;
        private int c7;
        private int state;
        private int offset;

        public Base32EncodingCodePointIterator(boolean addPadding) {
            this.addPadding = addPadding;
        }

        @Override
        public boolean hasNext() {
            return this.state == 0 && ByteIterator.this.hasNext() || this.state > 0 && this.state < 41;
        }

        @Override
        public boolean hasPrev() {
            return this.offset > 0;
        }

        abstract int calc0(int var1);

        abstract int calc1(int var1, int var2);

        abstract int calc2(int var1);

        abstract int calc3(int var1, int var2);

        abstract int calc4(int var1, int var2);

        abstract int calc5(int var1);

        abstract int calc6(int var1, int var2);

        abstract int calc7(int var1);

        @Override
        public int next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.offset;
            switch (this.state) {
                case 0: {
                    assert (ByteIterator.this.hasNext());
                    int b0 = ByteIterator.this.next();
                    this.c0 = this.calc0(b0);
                    if (!ByteIterator.this.hasNext()) {
                        this.c1 = this.calc1(b0, 0);
                        this.state = 10;
                        return this.c0;
                    }
                    int b1 = ByteIterator.this.next();
                    this.c1 = this.calc1(b0, b1);
                    this.c2 = this.calc2(b1);
                    if (!ByteIterator.this.hasNext()) {
                        this.c3 = this.calc3(b1, 0);
                        this.state = 18;
                        return this.c0;
                    }
                    int b2 = ByteIterator.this.next();
                    this.c3 = this.calc3(b1, b2);
                    if (!ByteIterator.this.hasNext()) {
                        this.c4 = this.calc4(b2, 0);
                        this.state = 26;
                        return this.c0;
                    }
                    int b3 = ByteIterator.this.next();
                    this.c4 = this.calc4(b2, b3);
                    this.c5 = this.calc5(b3);
                    if (!ByteIterator.this.hasNext()) {
                        this.c6 = this.calc6(b3, 0);
                        this.state = 34;
                        return this.c0;
                    }
                    int b4 = ByteIterator.this.next();
                    this.c6 = this.calc6(b3, b4);
                    this.c7 = this.calc7(b4);
                    this.state = 2;
                    return this.c0;
                }
                case 1: 
                case 9: 
                case 17: 
                case 25: 
                case 33: {
                    ++this.state;
                    return this.c0;
                }
                case 2: 
                case 18: 
                case 26: 
                case 34: {
                    ++this.state;
                    return this.c1;
                }
                case 3: 
                case 19: 
                case 27: 
                case 35: {
                    ++this.state;
                    return this.c2;
                }
                case 4: 
                case 28: 
                case 36: {
                    ++this.state;
                    return this.c3;
                }
                case 5: 
                case 37: {
                    ++this.state;
                    return this.c4;
                }
                case 6: 
                case 38: {
                    ++this.state;
                    return this.c5;
                }
                case 7: {
                    this.state = 8;
                    return this.c6;
                }
                case 8: {
                    this.state = 0;
                    return this.c7;
                }
                case 10: {
                    this.state = this.addPadding ? 11 : 41;
                    return this.c1;
                }
                case 20: {
                    this.state = this.addPadding ? 21 : 42;
                    return this.c3;
                }
                case 29: {
                    this.state = this.addPadding ? 30 : 43;
                    return this.c4;
                }
                case 39: {
                    this.state = this.addPadding ? 40 : 44;
                    return this.c6;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 21: 
                case 22: 
                case 23: 
                case 30: 
                case 31: {
                    ++this.state;
                    return 61;
                }
                case 16: {
                    this.state = 41;
                    return 61;
                }
                case 24: {
                    this.state = 42;
                    return 61;
                }
                case 32: {
                    this.state = 43;
                    return 61;
                }
                case 40: {
                    this.state = 44;
                    return 61;
                }
            }
            throw Assert.impossibleSwitchCase(this.state);
        }

        @Override
        public int peekNext() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 0: {
                    assert (ByteIterator.this.hasNext());
                    int b0 = ByteIterator.this.next();
                    this.c0 = this.calc0(b0);
                    if (!ByteIterator.this.hasNext()) {
                        this.c1 = this.calc1(b0, 0);
                        this.state = 9;
                        return this.c0;
                    }
                    int b1 = ByteIterator.this.next();
                    this.c1 = this.calc1(b0, b1);
                    this.c2 = this.calc2(b1);
                    if (!ByteIterator.this.hasNext()) {
                        this.c3 = this.calc3(b1, 0);
                        this.state = 17;
                        return this.c0;
                    }
                    int b2 = ByteIterator.this.next();
                    this.c3 = this.calc3(b1, b2);
                    if (!ByteIterator.this.hasNext()) {
                        this.c4 = this.calc4(b2, 0);
                        this.state = 25;
                        return this.c0;
                    }
                    int b3 = ByteIterator.this.next();
                    this.c4 = this.calc4(b2, b3);
                    this.c5 = this.calc5(b3);
                    if (!ByteIterator.this.hasNext()) {
                        this.c6 = this.calc6(b3, 0);
                        this.state = 33;
                        return this.c0;
                    }
                    int b4 = ByteIterator.this.next();
                    this.c6 = this.calc6(b3, b4);
                    this.c7 = this.calc7(b4);
                    this.state = 1;
                    return this.c0;
                }
                case 1: 
                case 9: 
                case 17: 
                case 25: 
                case 33: {
                    return this.c0;
                }
                case 2: 
                case 10: 
                case 18: 
                case 26: 
                case 34: {
                    return this.c1;
                }
                case 3: 
                case 19: 
                case 27: 
                case 35: {
                    return this.c2;
                }
                case 4: 
                case 20: 
                case 28: 
                case 36: {
                    return this.c3;
                }
                case 5: 
                case 29: 
                case 37: {
                    return this.c4;
                }
                case 6: 
                case 38: {
                    return this.c5;
                }
                case 7: 
                case 39: {
                    return this.c6;
                }
                case 8: {
                    return this.c7;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 30: 
                case 31: 
                case 32: 
                case 40: {
                    return 61;
                }
            }
            throw Assert.impossibleSwitchCase(this.state);
        }

        @Override
        public int prev() throws NoSuchElementException {
            if (!this.hasPrev()) {
                throw new NoSuchElementException();
            }
            --this.offset;
            switch (this.state) {
                case 33: {
                    ByteIterator.this.prev();
                }
                case 25: {
                    ByteIterator.this.prev();
                }
                case 17: {
                    ByteIterator.this.prev();
                }
                case 9: {
                    ByteIterator.this.prev();
                }
                case 0: 
                case 1: 
                case 45: {
                    int b4 = ByteIterator.this.prev();
                    int b3 = ByteIterator.this.prev();
                    int b2 = ByteIterator.this.prev();
                    int b1 = ByteIterator.this.prev();
                    int b0 = ByteIterator.this.prev();
                    this.c0 = this.calc0(b0);
                    this.c1 = this.calc1(b0, b1);
                    this.c2 = this.calc2(b1);
                    this.c3 = this.calc3(b1, b2);
                    this.c4 = this.calc4(b2, b3);
                    this.c5 = this.calc5(b3);
                    this.c6 = this.calc6(b3, b4);
                    this.c7 = this.calc7(b4);
                    this.state = 8;
                    return this.c7;
                }
                case 2: 
                case 10: 
                case 18: 
                case 26: 
                case 34: {
                    --this.state;
                    return this.c0;
                }
                case 3: 
                case 11: 
                case 19: 
                case 27: 
                case 35: {
                    --this.state;
                    return this.c1;
                }
                case 4: 
                case 20: 
                case 28: 
                case 36: {
                    --this.state;
                    return this.c2;
                }
                case 5: 
                case 21: 
                case 29: 
                case 37: {
                    --this.state;
                    return this.c3;
                }
                case 6: 
                case 30: 
                case 38: {
                    --this.state;
                    return this.c4;
                }
                case 7: 
                case 39: {
                    --this.state;
                    return this.c5;
                }
                case 8: 
                case 40: {
                    --this.state;
                    return this.c6;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 31: 
                case 32: {
                    --this.state;
                    return 61;
                }
                case 41: {
                    if (this.addPadding) {
                        this.state = 16;
                        return 61;
                    }
                    this.state = 10;
                    return this.c1;
                }
                case 42: {
                    if (this.addPadding) {
                        this.state = 24;
                        return 61;
                    }
                    this.state = 20;
                    return this.c3;
                }
                case 43: {
                    if (this.addPadding) {
                        this.state = 32;
                        return 61;
                    }
                    this.state = 29;
                    return this.c4;
                }
                case 44: {
                    if (this.addPadding) {
                        this.state = 40;
                        return 61;
                    }
                    this.state = 39;
                    return this.c6;
                }
            }
            throw Assert.impossibleSwitchCase(this.state);
        }

        @Override
        public int peekPrev() throws NoSuchElementException {
            if (!this.hasPrev()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 33: {
                    ByteIterator.this.prev();
                }
                case 25: {
                    ByteIterator.this.prev();
                }
                case 17: {
                    ByteIterator.this.prev();
                }
                case 9: {
                    ByteIterator.this.prev();
                }
                case 0: 
                case 1: 
                case 45: {
                    int result = this.calc7(ByteIterator.this.peekPrev());
                    if (this.state == 9) {
                        ByteIterator.this.next();
                    } else if (this.state == 17) {
                        ByteIterator.this.next();
                        ByteIterator.this.next();
                    } else if (this.state == 25) {
                        ByteIterator.this.next();
                        ByteIterator.this.next();
                        ByteIterator.this.next();
                    } else if (this.state == 33) {
                        ByteIterator.this.next();
                        ByteIterator.this.next();
                        ByteIterator.this.next();
                        ByteIterator.this.next();
                    }
                    return result;
                }
                case 2: 
                case 10: 
                case 18: 
                case 26: 
                case 34: {
                    return this.c0;
                }
                case 3: 
                case 11: 
                case 19: 
                case 27: 
                case 35: {
                    return this.c1;
                }
                case 4: 
                case 20: 
                case 28: 
                case 36: {
                    return this.c2;
                }
                case 5: 
                case 21: 
                case 29: 
                case 37: {
                    return this.c3;
                }
                case 6: 
                case 30: 
                case 38: {
                    return this.c4;
                }
                case 7: 
                case 39: {
                    return this.c5;
                }
                case 8: 
                case 40: {
                    return this.c6;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 22: 
                case 23: 
                case 24: 
                case 31: 
                case 32: {
                    return 61;
                }
                case 41: {
                    return this.addPadding ? 61 : this.c1;
                }
                case 42: {
                    return this.addPadding ? 61 : this.c3;
                }
                case 43: {
                    return this.addPadding ? 61 : this.c4;
                }
                case 44: {
                    return this.addPadding ? 61 : this.c6;
                }
            }
            throw Assert.impossibleSwitchCase(this.state);
        }

        @Override
        public int offset() {
            return this.offset;
        }
    }

    abstract class Base64EncodingCodePointIterator
    extends CodePointIterator {
        private final boolean addPadding;
        private int c0;
        private int c1;
        private int c2;
        private int c3;
        private int state;
        private int offset;

        public Base64EncodingCodePointIterator(boolean addPadding) {
            this.addPadding = addPadding;
        }

        @Override
        public boolean hasNext() {
            return this.state == 0 && ByteIterator.this.hasNext() || this.state > 0 && this.state < 13;
        }

        @Override
        public boolean hasPrev() {
            return this.offset > 0;
        }

        abstract int calc0(int var1);

        abstract int calc1(int var1, int var2);

        abstract int calc2(int var1, int var2);

        abstract int calc3(int var1);

        @Override
        public int next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.offset;
            switch (this.state) {
                case 0: {
                    assert (ByteIterator.this.hasNext());
                    int b0 = ByteIterator.this.next();
                    this.c0 = this.calc0(b0);
                    if (!ByteIterator.this.hasNext()) {
                        this.c1 = this.calc1(b0, 0);
                        this.state = 6;
                        return this.c0;
                    }
                    int b1 = ByteIterator.this.next();
                    this.c1 = this.calc1(b0, b1);
                    if (!ByteIterator.this.hasNext()) {
                        this.c2 = this.calc2(b1, 0);
                        this.state = 10;
                        return this.c0;
                    }
                    int b2 = ByteIterator.this.next();
                    this.c2 = this.calc2(b1, b2);
                    this.c3 = this.calc3(b2);
                    this.state = 2;
                    return this.c0;
                }
                case 1: {
                    this.state = 2;
                    return this.c0;
                }
                case 2: {
                    this.state = 3;
                    return this.c1;
                }
                case 3: {
                    this.state = 4;
                    return this.c2;
                }
                case 4: {
                    this.state = 0;
                    return this.c3;
                }
                case 5: {
                    this.state = 6;
                    return this.c0;
                }
                case 6: {
                    this.state = this.addPadding ? 7 : 13;
                    return this.c1;
                }
                case 7: {
                    this.state = 8;
                    return 61;
                }
                case 8: {
                    this.state = 13;
                    return 61;
                }
                case 9: {
                    this.state = 10;
                    return this.c0;
                }
                case 10: {
                    this.state = 11;
                    return this.c1;
                }
                case 11: {
                    this.state = this.addPadding ? 12 : 14;
                    return this.c2;
                }
                case 12: {
                    this.state = 14;
                    return 61;
                }
            }
            throw Assert.impossibleSwitchCase(this.state);
        }

        @Override
        public int peekNext() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 0: {
                    assert (ByteIterator.this.hasNext());
                    int b0 = ByteIterator.this.next();
                    this.c0 = this.calc0(b0);
                    if (!ByteIterator.this.hasNext()) {
                        this.c1 = this.calc1(b0, 0);
                        this.state = 5;
                        return this.c0;
                    }
                    int b1 = ByteIterator.this.next();
                    this.c1 = this.calc1(b0, b1);
                    if (!ByteIterator.this.hasNext()) {
                        this.c2 = this.calc2(b1, 0);
                        this.state = 9;
                        return this.c0;
                    }
                    int b2 = ByteIterator.this.next();
                    this.c2 = this.calc2(b1, b2);
                    this.c3 = this.calc3(b2);
                    this.state = 1;
                    return this.c0;
                }
                case 1: {
                    return this.c0;
                }
                case 2: {
                    return this.c1;
                }
                case 3: {
                    return this.c2;
                }
                case 4: {
                    return this.c3;
                }
                case 5: {
                    return this.c0;
                }
                case 6: {
                    return this.c1;
                }
                case 7: {
                    return 61;
                }
                case 8: {
                    return 61;
                }
                case 9: {
                    return this.c0;
                }
                case 10: {
                    return this.c1;
                }
                case 11: {
                    return this.c2;
                }
                case 12: {
                    return 61;
                }
            }
            throw Assert.impossibleSwitchCase(this.state);
        }

        @Override
        public int prev() throws NoSuchElementException {
            if (!this.hasPrev()) {
                throw new NoSuchElementException();
            }
            --this.offset;
            switch (this.state) {
                case 0: 
                case 1: 
                case 5: 
                case 9: 
                case 15: {
                    int b2 = ByteIterator.this.prev();
                    int b1 = ByteIterator.this.prev();
                    int b0 = ByteIterator.this.prev();
                    this.c0 = this.calc0(b0);
                    this.c1 = this.calc1(b0, b1);
                    this.c2 = this.calc2(b1, b2);
                    this.c3 = this.calc3(b2);
                    this.state = 4;
                    return this.c3;
                }
                case 2: {
                    this.state = 1;
                    return this.c0;
                }
                case 3: {
                    this.state = 2;
                    return this.c1;
                }
                case 4: {
                    this.state = 3;
                    return this.c2;
                }
                case 6: {
                    this.state = 5;
                    return this.c0;
                }
                case 7: {
                    this.state = 6;
                    return this.c1;
                }
                case 8: {
                    this.state = 7;
                    return 61;
                }
                case 10: {
                    this.state = 9;
                    return this.c0;
                }
                case 11: {
                    this.state = 10;
                    return this.c1;
                }
                case 12: {
                    this.state = 11;
                    return this.c2;
                }
                case 13: {
                    this.state = 8;
                    return 61;
                }
                case 14: {
                    this.state = 12;
                    return 61;
                }
            }
            throw Assert.impossibleSwitchCase(this.state);
        }

        @Override
        public int peekPrev() throws NoSuchElementException {
            if (!this.hasPrev()) {
                throw new NoSuchElementException();
            }
            switch (this.state) {
                case 0: 
                case 1: 
                case 5: 
                case 9: 
                case 15: {
                    return this.calc3(ByteIterator.this.peekPrev());
                }
                case 2: {
                    return this.c0;
                }
                case 3: {
                    return this.c1;
                }
                case 4: {
                    return this.c2;
                }
                case 6: {
                    return this.c0;
                }
                case 7: {
                    return this.c1;
                }
                case 8: {
                    return 61;
                }
                case 10: {
                    return this.c0;
                }
                case 11: {
                    return this.c1;
                }
                case 12: {
                    return this.c2;
                }
                case 13: {
                    return 61;
                }
                case 14: {
                    return 61;
                }
            }
            throw Assert.impossibleSwitchCase(this.state);
        }

        @Override
        public int offset() {
            return this.offset;
        }
    }
}

