/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.graphics.Graphics;
import org.aesh.graphics.GraphicsConfiguration;
import org.aesh.readline.Prompt;
import org.aesh.readline.ReadlineConsole;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;

public class AeshGraphicsExample {
    public static void main(String[] args) throws CommandLineParserException, IOException {
        SettingsBuilder builder = SettingsBuilder.builder().logging(true);
        builder.enableMan(true);
        CommandRegistry registry = new AeshCommandRegistryBuilder().command(ExitCommand.class).command(new GraphicsCommand()).create();
        Settings<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> settings = builder.commandRegistry(registry).build();
        ReadlineConsole console = new ReadlineConsole(settings);
        console.setPrompt(new Prompt("[aesh@rules]$ "));
        console.start();
    }

    @CommandDefinition(name="gfx", description="")
    public static class GraphicsCommand
    implements Command {
        private CommandInvocation invocation;
        private Graphics g;

        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            this.invocation = commandInvocation;
            this.invocation.getShell().enableAlternateBuffer();
            this.doGfx();
            return CommandResult.SUCCESS;
        }

        public void waitForInput() {
            try {
                while (!this.invocation.input().equals(Key.q)) {
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.g != null) {
                this.g.clearAndShowCursor();
            }
            this.invocation.getShell().enableMainBuffer();
        }

        private void doGfx() {
            try {
                GraphicsConfiguration gc = null;
                this.g = gc.getGraphics();
                this.g.setColor(new TerminalColor(Color.BLUE, Color.DEFAULT));
                this.g.drawRect(20, 10, 20, 4);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.RED, Color.DEFAULT));
                this.g.drawRect(50, 5, 10, 8);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.DEFAULT, Color.YELLOW));
                this.g.fillRect(0, 15, 16, 10);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.CYAN, Color.DEFAULT));
                this.g.drawString("\u00c6SH", 100, 25);
                this.g.drawString("RULES", 100, 26);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.WHITE, Color.WHITE));
                this.g.drawRect(80, 23, 40, 5);
                Thread.sleep(500L);
                this.g.flush();
                this.g.setColor(new TerminalColor(Color.BLUE, Color.DEFAULT));
                this.g.drawCircle(100, 10, 5);
                this.g.flush();
                Thread.sleep(500L);
                this.g.setColor(new TerminalColor(Color.DEFAULT, Color.DEFAULT));
                this.g.drawLine(0, 0, 50, 20);
                this.g.flush();
                Thread.sleep(1500L);
                this.g.setColor(new TerminalColor(Color.DEFAULT, Color.RED));
                int j = 0;
                for (int i = 0; i < 100; ++i) {
                    this.g.clear();
                    this.g.fillRect(i, 15 + j, 20, 8);
                    this.g.flush();
                    Thread.sleep(50L);
                    if (i > 10 && i < 20 || i > 30 && i < 40) {
                        ++j;
                    }
                    if (i >= 10 && (i <= 20 || i >= 30) && (i <= 40 || i >= 50)) continue;
                    --j;
                }
                this.waitForInput();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @CommandDefinition(name="exit", description="exit the program")
    public static class ExitCommand
    implements Command {
        public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
            commandInvocation.stop();
            return CommandResult.SUCCESS;
        }
    }
}

