/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.cli;

import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.patching.cli.AbstractDistributionCommand;
import org.jboss.as.patching.tool.PatchOperationBuilder;

@CommandDefinition(name="abstract-override-cmd", description="")
abstract class PatchOverrideCommand
extends AbstractDistributionCommand {
    @Option(name="override-all", hasValue=false, required=false)
    boolean overrideAll;
    @Option(name="override-modules", hasValue=false, required=false)
    boolean overrideModules;
    @Option(name="override", hasValue=true, required=false)
    String overrideList;
    @Option(name="preserve", hasValue=true, required=false)
    String preserveList;

    protected PatchOverrideCommand(String action) {
        super(action);
    }

    protected abstract PatchOperationBuilder createUnconfiguredOperationBuilder(CommandContext var1) throws CommandException;

    @Override
    protected PatchOperationBuilder createPatchOperationBuilder(CommandContext ctx) throws CommandException {
        PatchOperationBuilder builder = this.createUnconfiguredOperationBuilder(ctx);
        this.configureBuilder(builder);
        return builder;
    }

    private void configureBuilder(PatchOperationBuilder builder) throws CommandException {
        if (this.overrideModules) {
            builder.ignoreModuleChanges();
        }
        if (this.overrideAll) {
            builder.overrideAll();
        }
        if (this.overrideList != null) {
            for (String path : this.overrideList.split(",+")) {
                builder.overrideItem(path);
            }
        }
        if (this.preserveList != null) {
            for (String path : this.preserveList.split(",+")) {
                builder.preserveItem(path);
            }
        }
    }
}

