/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.registry;

import org.aesh.command.Command;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.container.CommandContainerBuilder;
import org.aesh.command.impl.container.AeshCommandContainer;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.impl.registry.MutableCommandRegistryImpl;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistry;

public class AeshCommandRegistryBuilder {
    private final MutableCommandRegistryImpl commandRegistry = new MutableCommandRegistryImpl();

    public AeshCommandRegistryBuilder containerBuilder(CommandContainerBuilder builder) {
        this.commandRegistry.setCommandContainerBuilder(builder);
        return this;
    }

    public AeshCommandRegistryBuilder command(Class<? extends Command> command) throws CommandLineParserException {
        this.commandRegistry.addCommand(command);
        return this;
    }

    public AeshCommandRegistryBuilder commands(Class<? extends Command> ... commands) throws CommandLineParserException {
        for (Class<? extends Command> c : commands) {
            this.commandRegistry.addCommand(c);
        }
        return this;
    }

    public AeshCommandRegistryBuilder command(ProcessedCommand processedCommand) {
        this.commandRegistry.addCommand(new AeshCommandContainer(processedCommand));
        return this;
    }

    public AeshCommandRegistryBuilder command(CommandContainer commandContainer) {
        this.commandRegistry.addCommand(commandContainer);
        return this;
    }

    public AeshCommandRegistryBuilder command(CommandLineParser parser) {
        this.commandRegistry.addCommand(new AeshCommandContainer(parser));
        return this;
    }

    public AeshCommandRegistryBuilder command(Command command) throws CommandLineParserException {
        this.commandRegistry.addCommand(command);
        return this;
    }

    public CommandRegistry create() {
        return this.commandRegistry;
    }
}

