/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.function.Consumer;
import java.util.logging.Logger;
import org.aesh.command.CommandException;
import org.aesh.command.Execution;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.validator.CommandValidatorException;
import org.aesh.readline.ProcessManager;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Signal;
import org.aesh.util.LoggerUtil;
import org.aesh.utils.Config;

public class Process
extends Thread
implements Consumer<Signal> {
    private final Connection conn;
    private final Execution<? extends CommandInvocation> execution;
    private final ProcessManager manager;
    private volatile boolean running;
    private static final Logger LOGGER = LoggerUtil.getLogger(Process.class.getName());
    private int pid;

    public Process(ProcessManager manager, Connection conn, Execution<? extends CommandInvocation> execution) {
        this.manager = manager;
        this.conn = conn;
        this.execution = execution;
    }

    @Override
    public void accept(Signal signal) {
        switch (signal) {
            case INT: {
                if (!this.running) break;
                LOGGER.info("got interrupted in Task");
                this.interrupt();
            }
        }
    }

    @Override
    public void run() {
        this.conn.setSignalHandler(this);
        this.running = true;
        this.pid = (int)Thread.currentThread().getId();
        try {
            this.execution.execute();
        }
        catch (CommandException | CommandValidatorException e) {
            this.conn.write(e.getMessage() + Config.getLineSeparator());
        }
        catch (InterruptedException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.running = false;
            if (this.conn.getSignalHandler() != null) {
                this.conn.setSignalHandler(null);
            }
            if (this.conn.getStdinHandler() != null) {
                this.conn.setStdinHandler(null);
            }
            this.manager.processFinished(this);
        }
    }

    public Execution<? extends CommandInvocation> execution() {
        return this.execution;
    }

    public int pid() {
        return this.pid;
    }
}

