/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.SuppressForbidden;

public class IndexSplitter {
    public SegmentInfos infos;
    FSDirectory fsDir;
    Path dir;

    @SuppressForbidden(reason="System.out required: command line tool")
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: IndexSplitter <srcDir> -l (list the segments and their sizes)");
            System.err.println("IndexSplitter <srcDir> <destDir> <segments>+");
            System.err.println("IndexSplitter <srcDir> -d (delete the following segments)");
            return;
        }
        Path srcDir = Paths.get(args[0], new String[0]);
        IndexSplitter is = new IndexSplitter(srcDir);
        if (!Files.exists(srcDir, new LinkOption[0])) {
            throw new Exception("srcdir:" + srcDir.toAbsolutePath() + " doesn't exist");
        }
        if (args[1].equals("-l")) {
            is.listSegments();
        } else if (args[1].equals("-d")) {
            ArrayList<String> segs = new ArrayList<String>();
            for (int x = 2; x < args.length; ++x) {
                segs.add(args[x]);
            }
            is.remove(segs.toArray(new String[0]));
        } else {
            Path targetDir = Paths.get(args[1], new String[0]);
            ArrayList<String> segs = new ArrayList<String>();
            for (int x = 2; x < args.length; ++x) {
                segs.add(args[x]);
            }
            is.split(targetDir, segs.toArray(new String[0]));
        }
    }

    public IndexSplitter(Path dir) throws IOException {
        this.dir = dir;
        this.fsDir = FSDirectory.open((Path)dir);
        this.infos = SegmentInfos.readLatestCommit((Directory)this.fsDir);
    }

    @SuppressForbidden(reason="System.out required: command line tool")
    public void listSegments() throws IOException {
        DecimalFormat formatter = new DecimalFormat("###,###.###", DecimalFormatSymbols.getInstance(Locale.ROOT));
        for (int x = 0; x < this.infos.size(); ++x) {
            SegmentCommitInfo info = this.infos.info(x);
            String sizeStr = formatter.format(info.sizeInBytes());
            System.out.println(info.info.name + " " + sizeStr);
        }
    }

    private int getIdx(String name) {
        for (int x = 0; x < this.infos.size(); ++x) {
            if (!name.equals(this.infos.info((int)x).info.name)) continue;
            return x;
        }
        return -1;
    }

    private SegmentCommitInfo getInfo(String name) {
        for (int x = 0; x < this.infos.size(); ++x) {
            if (!name.equals(this.infos.info((int)x).info.name)) continue;
            return this.infos.info(x);
        }
        return null;
    }

    public void remove(String[] segs) throws IOException {
        for (String n : segs) {
            int idx = this.getIdx(n);
            this.infos.remove(idx);
        }
        this.infos.changed();
        this.infos.commit((Directory)this.fsDir);
    }

    public void split(Path destDir, String[] segs) throws IOException {
        Files.createDirectories(destDir, new FileAttribute[0]);
        FSDirectory destFSDir = FSDirectory.open((Path)destDir);
        SegmentInfos destInfos = new SegmentInfos();
        destInfos.counter = this.infos.counter;
        for (String n : segs) {
            SegmentCommitInfo infoPerCommit = this.getInfo(n);
            SegmentInfo info = infoPerCommit.info;
            SegmentInfo newInfo = new SegmentInfo((Directory)destFSDir, info.getVersion(), info.name, info.maxDoc(), info.getUseCompoundFile(), info.getCodec(), info.getDiagnostics(), info.getId(), new HashMap());
            destInfos.add(new SegmentCommitInfo(newInfo, infoPerCommit.getDelCount(), infoPerCommit.getDelGen(), infoPerCommit.getFieldInfosGen(), infoPerCommit.getDocValuesGen()));
            Collection files = infoPerCommit.files();
            for (String srcName : files) {
                Path srcFile = this.dir.resolve(srcName);
                Path destFile = destDir.resolve(srcName);
                Files.copy(srcFile, destFile, new CopyOption[0]);
            }
        }
        destInfos.changed();
        destInfos.commit((Directory)destFSDir);
    }
}

