/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.serializer.AbstractDateTimeDeserializer;

public class InstantTypeDeserializer
extends AbstractDateTimeDeserializer<Instant> {
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_INSTANT.withZone(UTC);

    public InstantTypeDeserializer(JsonBindingModel model) {
        super(Instant.class, model);
    }

    @Override
    protected Instant fromInstant(Instant instant) {
        return instant;
    }

    @Override
    protected Instant parseDefault(String jsonValue, Locale locale) {
        return Instant.from(DEFAULT_FORMATTER.withLocale(locale).parse(jsonValue));
    }

    @Override
    protected Instant parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        return Instant.from(this.getZonedFormatter(formatter).parse(jsonValue));
    }
}

