/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.spi.ManagedConnectionMetaData;

public class ManagedConnectionMetaDataImpl
implements ManagedConnectionMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    private String productName;
    private String productVersion;
    private int maxConnections;
    private String user;

    ManagedConnectionMetaDataImpl(Connection connection, String user) {
        try {
            if (connection != null && connection.getMetaData() != null) {
                this.productName = connection.getMetaData().getDatabaseProductName();
                this.productVersion = connection.getMetaData().getDatabaseProductVersion();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.productName == null) {
            this.productName = "";
        }
        if (this.productVersion == null) {
            this.productVersion = "";
        }
        this.maxConnections = 1;
        this.user = user;
    }

    public String getEISProductName() {
        return this.productName;
    }

    public String getEISProductVersion() {
        return this.productVersion;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public String getUserName() {
        return this.user;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedConnectionMetaDataImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append(" productName=").append(this.productName);
        sb.append(" productVersion=").append(this.productVersion);
        sb.append(" maxConnections=").append(this.maxConnections);
        sb.append(" user=").append(this.user);
        sb.append("]");
        return sb.toString();
    }
}

