/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import org.jboss.jca.adapters.jdbc.CachedCallableStatement;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedPreparedStatement;

public abstract class WrappedCallableStatement
extends WrappedPreparedStatement
implements CallableStatement {
    private final CallableStatement cs;

    public WrappedCallableStatement(WrappedConnection lc, CallableStatement cs, boolean spy, String jndiName, boolean doLocking) {
        super(lc, cs, spy, jndiName, doLocking, "CallableStatement");
        this.cs = cs;
    }

    @Override
    public CallableStatement getUnderlyingStatement() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            if (this.cs instanceof CachedCallableStatement) {
                CallableStatement callableStatement = ((CachedCallableStatement)this.cs).getUnderlyingCallableStatement();
                return callableStatement;
            }
            CallableStatement callableStatement = this.cs;
            return callableStatement;
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Object object = this.cs.getObject(parameterIndex);
                return object;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> typeMap) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, typeMap});
                }
                Object object = this.cs.getObject(parameterIndex, typeMap);
                return object;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Object object = this.cs.getObject(parameterName);
                return object;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> typeMap) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, typeMap});
                }
                Object object = this.cs.getObject(parameterName, typeMap);
                return object;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBoolean(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                boolean bl = this.cs.getBoolean(parameterIndex);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBoolean(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                boolean bl = this.cs.getBoolean(parameterName);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getByte(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                byte by = this.cs.getByte(parameterIndex);
                return by;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getByte(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                byte by = this.cs.getByte(parameterName);
                return by;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getShort(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                short s = this.cs.getShort(parameterIndex);
                return s;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getShort(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                short s = this.cs.getShort(parameterName);
                return s;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getInt(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                int n = this.cs.getInt(parameterIndex);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getInt(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                int n = this.cs.getInt(parameterName);
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getLong(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                long l = this.cs.getLong(parameterIndex);
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getLong(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                long l = this.cs.getLong(parameterName);
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getFloat(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                float f = this.cs.getFloat(parameterIndex);
                return f;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getFloat(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                float f = this.cs.getFloat(parameterName);
                return f;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDouble(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                double d = this.cs.getDouble(parameterIndex);
                return d;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDouble(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                double d = this.cs.getDouble(parameterName);
                return d;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBytes(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                byte[] byArray = this.cs.getBytes(parameterIndex);
                return byArray;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBytes(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                byte[] byArray = this.cs.getBytes(parameterName);
                return byArray;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getURL(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                URL uRL = this.cs.getURL(parameterIndex);
                return uRL;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getURL(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                URL uRL = this.cs.getURL(parameterName);
                return uRL;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getString(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                String string = this.cs.getString(parameterIndex);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getString(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                String string = this.cs.getString(parameterName);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getRef(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Ref ref = this.cs.getRef(parameterIndex);
                return ref;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getRef(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Ref ref = this.cs.getRef(parameterName);
                return ref;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTime(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Time time = this.cs.getTime(parameterIndex);
                return time;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Time getTime(int parameterIndex, Calendar calendar) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTime(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, calendar});
                }
                Time time = this.cs.getTime(parameterIndex, calendar);
                return time;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTime(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Time time = this.cs.getTime(parameterName);
                return time;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Time getTime(String parameterName, Calendar calendar) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTime(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, calendar});
                }
                Time time = this.cs.getTime(parameterName, calendar);
                return time;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDate(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Date date = this.cs.getDate(parameterIndex);
                return date;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Date getDate(int parameterIndex, Calendar calendar) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDate(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, calendar});
                }
                Date date = this.cs.getDate(parameterIndex, calendar);
                return date;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDate(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Date date = this.cs.getDate(parameterName);
                return date;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Date getDate(String parameterName, Calendar calendar) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getDate(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, calendar});
                }
                Date date = this.cs.getDate(parameterName, calendar);
                return date;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] registerOutParameter(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, sqlType});
                }
                this.cs.registerOutParameter(parameterIndex, sqlType);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] registerOutParameter(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, sqlType, scale});
                }
                this.cs.registerOutParameter(parameterIndex, sqlType, scale);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] registerOutParameter(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, sqlType, typeName});
                }
                this.cs.registerOutParameter(parameterIndex, sqlType, typeName);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] registerOutParameter(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, sqlType});
                }
                this.cs.registerOutParameter(parameterName, sqlType);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] registerOutParameter(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, sqlType, scale});
                }
                this.cs.registerOutParameter(parameterName, sqlType, scale);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] registerOutParameter(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, sqlType, typeName});
                }
                this.cs.registerOutParameter(parameterName, sqlType, typeName);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] wasNull()", (Object)this.jndiName, (Object)this.spyLoggingCategory);
                }
                boolean bl = this.cs.wasNull();
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBigDecimal(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, scale});
                }
                BigDecimal bigDecimal = this.cs.getBigDecimal(parameterIndex, scale);
                return bigDecimal;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBigDecimal(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                BigDecimal bigDecimal = this.cs.getBigDecimal(parameterIndex);
                return bigDecimal;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBigDecimal(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                BigDecimal bigDecimal = this.cs.getBigDecimal(parameterName);
                return bigDecimal;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTimestamp(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Timestamp timestamp = this.cs.getTimestamp(parameterIndex);
                return timestamp;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar calendar) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTimestamp(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, calendar});
                }
                Timestamp timestamp = this.cs.getTimestamp(parameterIndex, calendar);
                return timestamp;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTimestamp(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Timestamp timestamp = this.cs.getTimestamp(parameterName);
                return timestamp;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar calendar) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTimestamp(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, calendar});
                }
                Timestamp timestamp = this.cs.getTimestamp(parameterName, calendar);
                return timestamp;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBlob(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Blob blob = this.cs.getBlob(parameterIndex);
                return blob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getBlob(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Blob blob = this.cs.getBlob(parameterName);
                return blob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getClob(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Clob clob = this.cs.getClob(parameterIndex);
                return clob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getClob(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Clob clob = this.cs.getClob(parameterName);
                return clob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getArray(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Array array = this.cs.getArray(parameterIndex);
                return array;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getArray(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Array array = this.cs.getArray(parameterName);
                return array;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(String parameterName, boolean value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBoolean(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setBoolean(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(String parameterName, byte value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setByte(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setByte(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(String parameterName, short value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setShort(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setShort(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(String parameterName, int value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setInt(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setInt(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(String parameterName, long value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setLong(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setLong(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(String parameterName, float value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setFloat(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, Float.valueOf(value)});
                }
                this.cs.setFloat(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(String parameterName, double value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setDouble(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setDouble(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(String parameterName, URL value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setURL(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setURL(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(String parameterName, Time value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTime(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setTime(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(String parameterName, Time value, Calendar calendar) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTime(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value, calendar});
                }
                this.cs.setTime(parameterName, value, calendar);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(String parameterName, int value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNull(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setNull(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNull(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, sqlType, typeName});
                }
                this.cs.setNull(parameterName, sqlType, typeName);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(String parameterName, BigDecimal value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBigDecimal(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setBigDecimal(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(String parameterName, String value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setString(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setString(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(String parameterName, byte[] value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBytes(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, Arrays.toString(value)});
                }
                this.cs.setBytes(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(String parameterName, Date value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setDate(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setDate(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(String parameterName, Date value, Calendar calendar) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setDate(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value, calendar});
                }
                this.cs.setDate(parameterName, value, calendar);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(String parameterName, Timestamp value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTimestamp(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setTimestamp(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(String parameterName, Timestamp value, Calendar calendar) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTimestamp(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value, calendar});
                }
                this.cs.setTimestamp(parameterName, value, calendar);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(String parameterName, InputStream stream, int length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, stream, length});
                }
                this.cs.setAsciiStream(parameterName, stream, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(String parameterName, InputStream stream, int length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, stream, length});
                }
                this.cs.setBinaryStream(parameterName, stream, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(String parameterName, Object value, int sqlType, int scale) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setObject(%s, %s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value, sqlType, scale});
                }
                this.cs.setObject(parameterName, value, sqlType, scale);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(String parameterName, Object value, int sqlType) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setObject(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value, sqlType});
                }
                this.cs.setObject(parameterName, value, sqlType);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(String parameterName, Object value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setObject(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setObject(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, reader, length});
                }
                this.cs.setCharacterStream(parameterName, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getCharacterStream(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Reader reader = this.cs.getCharacterStream(parameterIndex);
                return reader;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getCharacterStream(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Reader reader = this.cs.getCharacterStream(parameterName);
                return reader;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNCharacterStream(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                Reader reader = this.cs.getNCharacterStream(parameterIndex);
                return reader;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNCharacterStream(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                Reader reader = this.cs.getCharacterStream(parameterName);
                return reader;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNClob(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                NClob nClob = this.cs.getNClob(parameterIndex);
                return nClob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNClob(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                NClob nClob = this.cs.getNClob(parameterName);
                return nClob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNString(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                String string = this.cs.getNString(parameterIndex);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getNString(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                String string = this.cs.getNString(parameterName);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getRowId(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                RowId rowId = this.cs.getRowId(parameterIndex);
                return rowId;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getRowId(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                RowId rowId = this.cs.getRowId(parameterName);
                return rowId;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getSQLXML(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterIndex);
                }
                SQLXML sQLXML = this.cs.getSQLXML(parameterIndex);
                return sQLXML;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getSQLXML(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)parameterName);
                }
                SQLXML sQLXML = this.cs.getSQLXML(parameterName);
                return sQLXML;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setAsciiStream(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, x, length});
                }
                this.cs.setAsciiStream(parameterName, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setAsciiStream(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, x});
                }
                this.cs.setAsciiStream(parameterName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBinaryStream(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, x, length});
                }
                this.cs.setBinaryStream(parameterName, x, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBinaryStream(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, x});
                }
                this.cs.setBinaryStream(parameterName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBlob(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, x});
                }
                this.cs.setBlob(parameterName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBlob(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, inputStream, length});
                }
                this.cs.setBlob(parameterName, inputStream, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setBlob(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, inputStream});
                }
                this.cs.setBlob(parameterName, inputStream);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, reader, length});
                }
                this.cs.setCharacterStream(parameterName, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setCharacterStream(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, reader});
                }
                this.cs.setCharacterStream(parameterName, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setClob(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, x});
                }
                this.cs.setClob(parameterName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setClob(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, reader, length});
                }
                this.cs.setClob(parameterName, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setClob(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, reader});
                }
                this.cs.setClob(parameterName, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNCharacterStream(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value, length});
                }
                this.cs.setNCharacterStream(parameterName, value, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNCharacterStream(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setNCharacterStream(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNClob(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setNClob(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNClob(%s, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, reader, length});
                }
                this.cs.setNClob(parameterName, reader, length);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNClob(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, reader});
                }
                this.cs.setNClob(parameterName, reader);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setNString(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, value});
                }
                this.cs.setNString(parameterName, value);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setRowId(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, x});
                }
                this.cs.setRowId(parameterName, x);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setSQLXML(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, xmlObject});
                }
                this.cs.setSQLXML(parameterName, xmlObject);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            T t;
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, type});
                }
                t = this.cs.getObject(parameterIndex, type);
            }
            catch (Throwable t2) {
                throw this.checkException(t2);
            }
            return t;
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            T t;
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getObject(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterName, type});
                }
                t = this.cs.getObject(parameterName, type);
            }
            catch (Throwable t2) {
                throw this.checkException(t2);
            }
            return t;
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    protected CallableStatement getWrappedObject() throws SQLException {
        return this.cs;
    }
}

