/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.wildfly;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.projectodd.vdx.core.Util;
import org.projectodd.vdx.core.ValidationContext;
import org.projectodd.vdx.core.schema.SchemaPathGate;
import org.projectodd.vdx.core.schema.SchemaPathPrefixProvider;

class SchemaDocRelationships
implements SchemaPathPrefixProvider,
SchemaPathGate {
    private QName rootElement = null;
    private final List<QName> prefix = new ArrayList<QName>();
    private final Set<QName> excludedRoots = new HashSet<QName>();

    SchemaDocRelationships() {
    }

    public List<QName> prefixFor(List<QName> path, ValidationContext ctx) {
        this.init(ctx);
        if (this.prefix.get(0).equals(path.get(0))) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.prefix);
    }

    public boolean allowPath(List<QName> path, ValidationContext ctx) {
        this.init(ctx);
        return !this.excludedRoots.contains(path.get(0));
    }

    private void init(ValidationContext ctx) {
        if (this.prefix.isEmpty()) {
            this.rootElement = Util.extractFirstElement((List)ctx.documentLines());
            this.prefix.add(this.rootElement);
            if (this.rootElement.getLocalPart().equals("domain")) {
                this.prefix.add(new QName(this.rootElement.getNamespaceURI(), "profiles"));
            }
            this.prefix.add(new QName(this.rootElement.getNamespaceURI(), "profile"));
            String uri = this.rootElement.getNamespaceURI();
            if (this.rootElement.getLocalPart().equals("server")) {
                this.excludedRoots.add(new QName(uri, "domain"));
                this.excludedRoots.add(new QName(uri, "host"));
            } else if (this.rootElement.getLocalPart().equals("domain")) {
                this.excludedRoots.add(new QName(uri, "server"));
                this.excludedRoots.add(new QName(uri, "host"));
            } else {
                this.excludedRoots.add(new QName(uri, "domain"));
                this.excludedRoots.add(new QName(uri, "server"));
            }
        }
    }
}

