/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public interface ReadableBuffer {
    public void put(ReadableBuffer var1);

    public byte get();

    public int getInt();

    public long getLong();

    public short getShort();

    public float getFloat();

    public double getDouble();

    public ReadableBuffer get(byte[] var1, int var2, int var3);

    public ReadableBuffer get(byte[] var1);

    public ReadableBuffer position(int var1);

    public ReadableBuffer slice();

    public ReadableBuffer flip();

    public ReadableBuffer limit(int var1);

    public int limit();

    public int remaining();

    public int position();

    public boolean hasRemaining();

    public ReadableBuffer duplicate();

    public ByteBuffer byteBuffer();

    public String readUTF8();

    public static final class ByteBufferReader
    implements ReadableBuffer {
        private static final Charset Charset_UTF8 = Charset.forName("UTF-8");
        private ByteBuffer buffer;

        public static ByteBufferReader allocate(int size) {
            ByteBuffer allocated = ByteBuffer.allocate(size);
            return new ByteBufferReader(allocated);
        }

        public ByteBufferReader(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public byte get() {
            return this.buffer.get();
        }

        @Override
        public int getInt() {
            return this.buffer.getInt();
        }

        @Override
        public long getLong() {
            return this.buffer.getLong();
        }

        @Override
        public short getShort() {
            return this.buffer.getShort();
        }

        @Override
        public float getFloat() {
            return this.buffer.getFloat();
        }

        @Override
        public double getDouble() {
            return this.buffer.getDouble();
        }

        @Override
        public int limit() {
            return this.buffer.limit();
        }

        @Override
        public ReadableBuffer get(byte[] data, int offset, int length) {
            this.buffer.get(data, offset, length);
            return this;
        }

        @Override
        public ReadableBuffer get(byte[] data) {
            this.buffer.get(data);
            return this;
        }

        @Override
        public ReadableBuffer flip() {
            this.buffer.flip();
            return this;
        }

        @Override
        public ReadableBuffer position(int position) {
            this.buffer.position(position);
            return this;
        }

        @Override
        public ReadableBuffer slice() {
            return new ByteBufferReader(this.buffer.slice());
        }

        @Override
        public ReadableBuffer limit(int limit) {
            this.buffer.limit(limit);
            return this;
        }

        @Override
        public int remaining() {
            return this.buffer.remaining();
        }

        @Override
        public int position() {
            return this.buffer.position();
        }

        @Override
        public boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        @Override
        public ReadableBuffer duplicate() {
            return new ByteBufferReader(this.buffer.duplicate());
        }

        @Override
        public ByteBuffer byteBuffer() {
            return this.buffer;
        }

        @Override
        public String readUTF8() {
            CharBuffer charBuf = Charset_UTF8.decode(this.buffer);
            return charBuf.toString();
        }

        @Override
        public void put(ReadableBuffer other) {
            this.buffer.put(other.byteBuffer());
        }
    }
}

