/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.payloads.PayloadFunction;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.BytesRef;

public class PayloadScoreQuery
extends SpanQuery {
    private final SpanQuery wrappedQuery;
    private final PayloadFunction function;

    public PayloadScoreQuery(SpanQuery wrappedQuery, PayloadFunction function) {
        this.wrappedQuery = wrappedQuery;
        this.function = function;
    }

    @Override
    public String getField() {
        return this.wrappedQuery.getField();
    }

    @Override
    public String toString(String field) {
        return "PayloadSpanQuery[" + this.wrappedQuery.toString(field) + "; " + this.function.toString() + "]";
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight innerWeight = this.wrappedQuery.createWeight(searcher, needsScores);
        if (!needsScores) {
            return innerWeight;
        }
        return new PayloadSpanWeight(searcher, innerWeight);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PayloadScoreQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PayloadScoreQuery that = (PayloadScoreQuery)o;
        if (this.wrappedQuery != null ? !this.wrappedQuery.equals(that.wrappedQuery) : that.wrappedQuery != null) {
            return false;
        }
        return !(this.function == null ? that.function != null : !this.function.equals(that.function));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.wrappedQuery != null ? this.wrappedQuery.hashCode() : 0);
        result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
        return result;
    }

    private class PayloadSpanScorer
    extends SpanScorer
    implements SpanCollector {
        private int payloadsSeen;
        private float payloadScore;

        private PayloadSpanScorer(Spans spans, SpanWeight weight, Similarity.SimScorer docScorer) throws IOException {
            super(spans, weight, docScorer);
        }

        @Override
        protected void doStartCurrentDoc() {
            this.payloadScore = 0.0f;
            this.payloadsSeen = 0;
        }

        @Override
        protected void doCurrentSpans() throws IOException {
            this.spans.collect(this);
        }

        @Override
        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            BytesRef payload = postings.getPayload();
            if (payload == null) {
                return;
            }
            float payloadFactor = this.docScorer.computePayloadFactor(this.docID(), this.spans.startPosition(), this.spans.endPosition(), payload);
            this.payloadScore = PayloadScoreQuery.this.function.currentScore(this.docID(), PayloadScoreQuery.this.getField(), this.spans.startPosition(), this.spans.endPosition(), this.payloadsSeen, this.payloadScore, payloadFactor);
            ++this.payloadsSeen;
        }

        protected float getPayloadScore() {
            return PayloadScoreQuery.this.function.docScore(this.docID(), PayloadScoreQuery.this.getField(), this.payloadsSeen, this.payloadScore);
        }

        protected Explanation getPayloadExplanation() {
            return PayloadScoreQuery.this.function.explain(this.docID(), PayloadScoreQuery.this.getField(), this.payloadsSeen, this.payloadScore);
        }

        protected float getSpanScore() throws IOException {
            return super.scoreCurrentDoc();
        }

        @Override
        protected float scoreCurrentDoc() throws IOException {
            return this.getSpanScore() * this.getPayloadScore();
        }

        @Override
        public void reset() {
        }
    }

    private class PayloadSpanWeight
    extends SpanWeight {
        private final SpanWeight innerWeight;

        public PayloadSpanWeight(IndexSearcher searcher, SpanWeight innerWeight) throws IOException {
            super(PayloadScoreQuery.this, searcher, null);
            this.innerWeight = innerWeight;
        }

        @Override
        public void extractTermContexts(Map<Term, TermContext> contexts) {
            this.innerWeight.extractTermContexts(contexts);
        }

        @Override
        public Spans getSpans(LeafReaderContext ctx, SpanWeight.Postings requiredPostings) throws IOException {
            return this.innerWeight.getSpans(ctx, requiredPostings.atLeast(SpanWeight.Postings.PAYLOADS));
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Spans spans = this.getSpans(context, SpanWeight.Postings.PAYLOADS);
            if (spans == null) {
                return null;
            }
            return new PayloadSpanScorer(spans, this, this.innerWeight.getSimScorer(context));
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.innerWeight.extractTerms(terms);
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.innerWeight.getValueForNormalization();
        }

        @Override
        public void normalize(float queryNorm, float topLevelBoost) {
            this.innerWeight.normalize(queryNorm, topLevelBoost);
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            PayloadSpanScorer scorer = (PayloadSpanScorer)this.scorer(context);
            if (scorer == null || scorer.advance(doc) != doc) {
                return Explanation.noMatch("No match", new Explanation[0]);
            }
            SpanWeight innerWeight = ((PayloadSpanWeight)scorer.getWeight()).innerWeight;
            Explanation innerExpl = innerWeight.explain(context, doc);
            scorer.freq();
            Explanation payloadExpl = scorer.getPayloadExplanation();
            return Explanation.match(scorer.scoreCurrentDoc(), "PayloadSpanQuery, product of:", innerExpl, payloadExpl);
        }
    }
}

