/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jackson.NodeType;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.diff.Diff;
import com.github.fge.jsonpatch.diff.DiffFactorizer;
import com.github.fge.jsonpatch.diff.DiffOperation;
import com.github.fge.jsonpatch.diff.LCS;
import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class JsonDiff {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    private JsonDiff() {
    }

    public static JsonNode asJson(JsonNode first, JsonNode second) {
        ArrayList diffs = Lists.newArrayList();
        JsonDiff.generateDiffs(diffs, JsonPointer.empty(), first, second);
        DiffFactorizer.factorizeDiffs(diffs);
        ArrayNode patch = FACTORY.arrayNode();
        for (Diff diff : diffs) {
            patch.add(diff.asJsonPatch());
        }
        return patch;
    }

    private static void generateDiffs(List<Diff> diffs, JsonPointer path, JsonNode first, JsonNode second) {
        NodeType secondType;
        if (EQUIVALENCE.equivalent((Object)first, (Object)second)) {
            return;
        }
        NodeType firstType = NodeType.getNodeType((JsonNode)first);
        if (firstType != (secondType = NodeType.getNodeType((JsonNode)second)) || !first.isContainerNode()) {
            diffs.add(new Diff(DiffOperation.REPLACE, path, second.deepCopy()));
            return;
        }
        if (firstType == NodeType.OBJECT) {
            JsonDiff.generateObjectDiffs(diffs, path, first, second);
        } else {
            JsonDiff.generateArrayDiffs(diffs, path, first, second);
        }
    }

    private static void generateObjectDiffs(List<Diff> diffs, JsonPointer path, JsonNode first, JsonNode second) {
        ArrayList inFirst = Lists.newArrayList((Iterator)first.fieldNames());
        ArrayList inSecond = Lists.newArrayList((Iterator)second.fieldNames());
        ArrayList fields = Lists.newArrayList((Iterable)inSecond);
        fields.removeAll(inFirst);
        for (String added : fields) {
            diffs.add(new Diff(DiffOperation.ADD, path.append(added), second.get(added).deepCopy()));
        }
        fields = Lists.newArrayList((Iterable)inFirst);
        fields.removeAll(inSecond);
        for (String removed : fields) {
            diffs.add(new Diff(DiffOperation.REMOVE, path.append(removed), first.get(removed).deepCopy()));
        }
        fields = Lists.newArrayList((Iterable)inFirst);
        fields.retainAll(inSecond);
        for (String common : fields) {
            JsonDiff.generateDiffs(diffs, path.append(common), first.get(common), second.get(common));
        }
    }

    private static void generateArrayDiffs(List<Diff> diffs, JsonPointer path, JsonNode first, JsonNode second) {
        List<JsonNode> lcs = LCS.getLCS(first, second);
        int firstSize = first.size();
        int secondSize = second.size();
        int lcsSize = lcs.size();
        int firstIndex = 0;
        int secondIndex = 0;
        int lcsIndex = 0;
        while (firstIndex < firstSize || secondIndex < secondSize) {
            JsonNode lcsElement;
            JsonNode firstElement = first.get(firstIndex);
            JsonNode secondElement = second.get(secondIndex);
            JsonNode jsonNode = lcsElement = lcsIndex < lcsSize ? lcs.get(lcsIndex) : null;
            if (firstElement == null) {
                diffs.add(new Diff(DiffOperation.ADD, path, firstIndex, -1, second.get(secondIndex).deepCopy()));
                ++secondIndex;
                continue;
            }
            if (EQUIVALENCE.equivalent((Object)firstElement, (Object)lcsElement)) {
                if (EQUIVALENCE.equivalent((Object)firstElement, (Object)secondElement)) {
                    ++firstIndex;
                    ++secondIndex;
                    ++lcsIndex;
                    continue;
                }
                diffs.add(new Diff(DiffOperation.ADD, path, firstIndex, secondIndex, second.get(secondIndex).deepCopy()));
                ++secondIndex;
                continue;
            }
            if (secondElement != null && !EQUIVALENCE.equivalent((Object)secondElement, (Object)lcsElement)) {
                if (firstIndex == secondIndex) {
                    JsonDiff.generateDiffs(diffs, path.append(firstIndex), firstElement, secondElement);
                } else {
                    diffs.add(new Diff(DiffOperation.REPLACE, path, firstIndex, secondIndex, second.get(secondIndex).deepCopy()));
                }
                ++firstIndex;
                ++secondIndex;
                continue;
            }
            diffs.add(new Diff(DiffOperation.REMOVE, path, firstIndex, secondIndex, first.get(firstIndex).deepCopy()));
            ++firstIndex;
        }
    }
}

