/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.RuntimeResourceRegistration;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.clustering.jgroups.subsystem.AuthProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.EncryptProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.GenericProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JDBCProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.MulticastSocketProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketBindingProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SocketDiscoveryProtocolResourceDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jgroups.PhysicalAddress;
import org.jgroups.stack.IpAddress;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class ProtocolRegistration
implements Registration<ManagementResourceRegistration> {
    private final ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory;
    private final Consumer<ResourceDescriptor> descriptorConfigurator;

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        PathElement path;
        ProtocolResourceDefinition.buildTransformation(version, parent);
        for (MulticastProtocol multicastProtocol : EnumSet.allOf(MulticastProtocol.class)) {
            SocketBindingProtocolResourceDefinition.addTransformations(version, parent.addChildResource(ProtocolResourceDefinition.pathElement(multicastProtocol.name())));
        }
        for (JdbcProtocol jdbcProtocol : EnumSet.allOf(JdbcProtocol.class)) {
            path = ProtocolResourceDefinition.pathElement(jdbcProtocol.name());
            if (JGroupsModel.VERSION_5_0_0.requiresTransformation(version)) {
                parent.rejectChildResource(path);
                continue;
            }
            JDBCProtocolResourceDefinition.addTransformations(version, parent.addChildResource(path));
        }
        for (EncryptProtocol encryptProtocol : EnumSet.allOf(EncryptProtocol.class)) {
            path = ProtocolResourceDefinition.pathElement(encryptProtocol.name());
            if (JGroupsModel.VERSION_5_0_0.requiresTransformation(version)) {
                parent.rejectChildResource(path);
                continue;
            }
            EncryptProtocolResourceDefinition.addTransformations(version, parent.addChildResource(path));
        }
        for (InitialHostsProtocol initialHostsProtocol : EnumSet.allOf(InitialHostsProtocol.class)) {
            path = ProtocolResourceDefinition.pathElement(initialHostsProtocol.name());
            if (JGroupsModel.VERSION_5_0_0.requiresTransformation(version)) {
                parent.rejectChildResource(path);
                continue;
            }
            SocketDiscoveryProtocolResourceDefinition.addTransformations(version, parent.addChildResource(path));
        }
        for (AuthProtocol authProtocol : EnumSet.allOf(AuthProtocol.class)) {
            path = ProtocolResourceDefinition.pathElement(authProtocol.name());
            if (JGroupsModel.VERSION_5_0_0.requiresTransformation(version)) {
                parent.rejectChildResource(path);
                continue;
            }
            AuthProtocolResourceDefinition.addTransformations(version, parent.addChildResource(path));
        }
    }

    ProtocolRegistration(ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        this.parentBuilderFactory = parentBuilderFactory;
        this.descriptorConfigurator = Consumers.empty();
    }

    ProtocolRegistration(ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory, RuntimeResourceRegistration runtimeResourceRegistration) {
        this.parentBuilderFactory = parentBuilderFactory;
        this.descriptorConfigurator = descriptor -> descriptor.addRuntimeResourceRegistration(runtimeResourceRegistration);
    }

    public void register(ManagementResourceRegistration registration) {
        new GenericProtocolResourceDefinition(this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
        for (MulticastProtocol multicastProtocol : EnumSet.allOf(MulticastProtocol.class)) {
            new SocketBindingProtocolResourceDefinition(multicastProtocol.name(), this.descriptorConfigurator, MulticastSocketProtocolConfigurationBuilder::new, this.parentBuilderFactory).register(registration);
        }
        for (JdbcProtocol jdbcProtocol : EnumSet.allOf(JdbcProtocol.class)) {
            new JDBCProtocolResourceDefinition(jdbcProtocol.name(), this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
            new GenericProtocolResourceDefinition(jdbcProtocol.name(), JGroupsModel.VERSION_5_0_0, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
        }
        for (EncryptProtocol encryptProtocol : EnumSet.allOf(EncryptProtocol.class)) {
            new EncryptProtocolResourceDefinition(encryptProtocol.name(), encryptProtocol.entryClass, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
            new GenericProtocolResourceDefinition(encryptProtocol.name(), JGroupsModel.VERSION_5_0_0, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
        }
        for (InitialHostsProtocol initialHostsProtocol : EnumSet.allOf(InitialHostsProtocol.class)) {
            new SocketDiscoveryProtocolResourceDefinition(initialHostsProtocol.name(), initialHostsProtocol.hostTransformer, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
            new GenericProtocolResourceDefinition(initialHostsProtocol.name(), JGroupsModel.VERSION_5_0_0, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
        }
        for (AuthProtocol authProtocol : EnumSet.allOf(AuthProtocol.class)) {
            new AuthProtocolResourceDefinition(authProtocol.name(), this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
            new GenericProtocolResourceDefinition(authProtocol.name(), JGroupsModel.VERSION_5_0_0, this.descriptorConfigurator, this.parentBuilderFactory).register(registration);
        }
    }

    static enum MulticastProtocol {
        MPING;

    }

    static enum JdbcProtocol {
        JDBC_PING;

    }

    static enum InitialHostsProtocol {
        TCPGOSSIP(InetSocketAddress.class, Function.identity()),
        TCPPING(PhysicalAddress.class, address -> new IpAddress(address.getAddress(), address.getPort()));

        Function<InetSocketAddress, ?> hostTransformer;

        private <A> InitialHostsProtocol(Class<A> hostClass, Function<InetSocketAddress, A> hostTransformer) {
            this.hostTransformer = hostTransformer;
        }
    }

    static enum EncryptProtocol {
        ASYM_ENCRYPT(KeyStore.PrivateKeyEntry.class),
        SYM_ENCRYPT(KeyStore.SecretKeyEntry.class);

        Class<? extends KeyStore.Entry> entryClass;

        private EncryptProtocol(Class<? extends KeyStore.Entry> entryClass) {
            this.entryClass = entryClass;
        }
    }

    static enum AuthProtocol {
        AUTH;

    }
}

