/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jgroups.JChannel;
import org.jgroups.blocks.locking.LockNotification;
import org.jgroups.blocks.locking.LockService;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.util.Owner;
import org.jgroups.util.Util;

public class LockServiceDemo
implements LockNotification {
    protected String props;
    protected JChannel ch;
    protected LockService lock_service;
    protected String name;

    public LockServiceDemo(String props, String name) {
        this.props = props;
        this.name = name;
    }

    public void start() throws Exception {
        this.ch = new JChannel(this.props);
        if (this.name != null) {
            this.ch.setName(this.name);
        }
        this.lock_service = new LockService(this.ch);
        this.lock_service.addLockListener(this);
        this.ch.connect("lock-cluster");
        JmxConfigurator.registerChannel(this.ch, Util.getMBeanServer(), "lock-service", this.ch.getClusterName(), true);
        try {
            this.loop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Util.close((Closeable)this.ch);
        }
    }

    public void start(JChannel ch) throws Exception {
        this.ch = ch;
        this.lock_service = new LockService(ch);
        this.lock_service.addLockListener(this);
        ch.connect("lock-cluster");
        JmxConfigurator.registerChannel(ch, Util.getMBeanServer(), "lock-service", ch.getClusterName(), true);
        try {
            this.loop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Util.close((Closeable)ch);
        }
    }

    @Override
    public void lockCreated(String name) {
    }

    @Override
    public void lockDeleted(String name) {
    }

    @Override
    public void locked(String lock_name, Owner owner) {
        System.out.println("\"" + lock_name + "\" locked by " + owner);
    }

    @Override
    public void unlocked(String lock_name, Owner owner) {
        System.out.println("\"" + lock_name + "\" unlocked by " + owner);
    }

    @Override
    public void awaiting(String lock_name, Owner owner) {
        System.out.println("awaiting \"" + lock_name + "\" by " + owner);
    }

    @Override
    public void awaited(String lock_name, Owner owner) {
        System.out.println("awaited \"" + lock_name + "\" by " + owner);
    }

    protected void loop() throws Exception {
        String line;
        while (this.ch.isConnected() && !(line = Util.readStringFromStdin(": ")).startsWith("quit") && !line.startsWith("exit")) {
            Object lock2;
            List<String> lock_names;
            if (line.startsWith("lock")) {
                lock_names = LockServiceDemo.parseLockNames(line.substring("lock".length()).trim());
                for (String lock_name : lock_names) {
                    lock2 = this.lock_service.getLock(lock_name);
                    lock2.lock();
                }
            } else if (line.startsWith("trylock")) {
                lock_names = LockServiceDemo.parseLockNames(line.substring("trylock".length()).trim());
                String tmp = lock_names.get(lock_names.size() - 1);
                Long timeout = -1L;
                try {
                    timeout = Long.parseLong(tmp);
                    lock_names.remove(lock_names.size() - 1);
                }
                catch (NumberFormatException lock2) {
                    // empty catch block
                }
                for (String lock_name : lock_names) {
                    Lock lock3 = this.lock_service.getLock(lock_name);
                    boolean rc = timeout < 0L ? lock3.tryLock() : lock3.tryLock(timeout, TimeUnit.MILLISECONDS);
                    if (rc) continue;
                    System.err.println("Failed locking \"" + lock_name + "\"");
                }
            } else if (line.startsWith("unlock")) {
                lock_names = LockServiceDemo.parseLockNames(line.substring("unlock".length()).trim());
                for (String lock_name : lock_names) {
                    if (lock_name.equalsIgnoreCase("all")) {
                        this.lock_service.unlockAll();
                        break;
                    }
                    lock2 = this.lock_service.getLock(lock_name);
                    if (lock2 == null) continue;
                    lock2.unlock();
                }
            } else if (line.startsWith("view")) {
                System.out.println("View: " + this.ch.getView());
            } else if (line.startsWith("help")) {
                LockServiceDemo.help();
            }
            this.printLocks();
        }
    }

    protected static List<String> parseLockNames(String line) {
        ArrayList<String> lock_names = new ArrayList<String>();
        if (line == null || line.isEmpty()) {
            return lock_names;
        }
        StringTokenizer tokenizer = new StringTokenizer(line);
        while (tokenizer.hasMoreTokens()) {
            lock_names.add(tokenizer.nextToken());
        }
        return lock_names;
    }

    protected void printLocks() {
        System.out.println("\n" + this.lock_service.printLocks());
    }

    public static void main(String[] args) throws Exception {
        String props = null;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (args[i].equals("-name")) {
                name = args[++i];
                continue;
            }
            LockServiceDemo.help();
            return;
        }
        LockServiceDemo demo = new LockServiceDemo(props, name);
        demo.start();
    }

    protected static void help() {
        System.out.println("\nLockServiceDemo [-props properties] [-name name]\nValid commands:\n\nlock (<lock name>)+\nunlock (<lock name> | \"ALL\")+\ntrylock (<lock name>)+ [<timeout>]\n");
        System.out.println("Example:\nlock lock lock2 lock3\nunlock all\ntrylock bela michelle 300");
    }
}

