/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.SetExecutor;
import org.apache.velocity.util.introspection.Introspector;
import org.slf4j.Logger;

public class SetPublicFieldExecutor
extends SetExecutor {
    private final Introspector introspector;
    private Field field = null;

    public SetPublicFieldExecutor(Logger logger, Introspector introspector, Class clazz, String string, Object object) {
        this.log = logger;
        this.introspector = introspector;
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            this.discover(clazz, string, object);
        }
    }

    @Override
    public boolean isAlive() {
        return this.getField() != null;
    }

    public Field getField() {
        return this.field;
    }

    protected void setField(Field field) {
        this.field = field;
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class clazz, String string, Object object) {
        try {
            Field field = this.introspector.getField(clazz, string);
            if (!Modifier.isFinal(field.getModifiers())) {
                this.setField(field);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            String string2 = "Exception while looking for public field '" + string;
            this.log.error(string2, (Throwable)exception);
            throw new VelocityException(string2, exception);
        }
    }

    @Override
    public Object execute(Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
        if (this.isAlive()) {
            Object object3 = this.getField().get(object);
            this.getField().set(object, object2);
            return object3;
        }
        return null;
    }
}

