/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.picketlink.config.http.AbstracHttpSecurityConfigurationChildBuilder;
import org.picketlink.config.http.AbstractHttpSecurityBuilder;
import org.picketlink.config.http.AuthenticationConfiguration;
import org.picketlink.config.http.AuthenticationConfigurationBuilder;
import org.picketlink.config.http.AuthorizationConfiguration;
import org.picketlink.config.http.AuthorizationConfigurationBuilder;
import org.picketlink.config.http.InboundHeaderConfiguration;
import org.picketlink.config.http.InboundHeaderConfigurationBuilder;
import org.picketlink.config.http.LogoutConfiguration;
import org.picketlink.config.http.LogoutConfigurationBuilder;
import org.picketlink.config.http.OutboundRedirectConfiguration;
import org.picketlink.config.http.OutboundRedirectConfigurationBuilder;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.config.http.PathConfigurationChildBuilder;
import org.picketlink.http.HttpMethod;

public class PathConfigurationBuilder
extends AbstracHttpSecurityConfigurationChildBuilder
implements PathConfigurationChildBuilder {
    private final String groupName;
    private final String uri;
    private Boolean secured;
    private AuthenticationConfigurationBuilder authenticationConfigBuilder;
    private AuthorizationConfigurationBuilder authorizationConfigurationBuilder;
    private InboundHeaderConfigurationBuilder inboundHeaderConfigurationBuilder;
    private LogoutConfigurationBuilder logoutConfigurationBuilder;
    private Set<HttpMethod> methods = new HashSet<HttpMethod>();
    private final List<OutboundRedirectConfigurationBuilder> redirects = new ArrayList<OutboundRedirectConfigurationBuilder>();

    PathConfigurationBuilder(String groupName, String uri, Boolean secured, AbstractHttpSecurityBuilder parentBuilder) {
        super(parentBuilder);
        this.groupName = groupName;
        this.uri = uri;
        this.secured = secured;
    }

    @Override
    public AuthenticationConfigurationBuilder authenticateWith() {
        if (this.authenticationConfigBuilder == null) {
            this.authenticationConfigBuilder = new AuthenticationConfigurationBuilder(this);
        }
        return this.authenticationConfigBuilder;
    }

    @Override
    public AuthorizationConfigurationBuilder authorizeWith() {
        if (this.authorizationConfigurationBuilder == null) {
            this.authorizationConfigurationBuilder = new AuthorizationConfigurationBuilder(this);
        }
        return this.authorizationConfigurationBuilder;
    }

    public LogoutConfigurationBuilder logout() {
        if (this.logoutConfigurationBuilder == null) {
            this.logoutConfigurationBuilder = new LogoutConfigurationBuilder(this);
        }
        return this.logoutConfigurationBuilder;
    }

    public InboundHeaderConfigurationBuilder withHeaders() {
        if (this.inboundHeaderConfigurationBuilder == null) {
            this.inboundHeaderConfigurationBuilder = new InboundHeaderConfigurationBuilder(this);
        }
        return this.inboundHeaderConfigurationBuilder;
    }

    public PathConfigurationBuilder withMethod(HttpMethod ... methods) {
        this.methods.addAll(Arrays.asList(methods));
        return this;
    }

    @Override
    public OutboundRedirectConfigurationBuilder redirectTo(String redirectUrl) {
        OutboundRedirectConfigurationBuilder builder = new OutboundRedirectConfigurationBuilder(this, redirectUrl);
        this.redirects.add(builder);
        return builder;
    }

    @Override
    public PathConfigurationBuilder unprotected() {
        this.secured = false;
        return this;
    }

    @Override
    protected PathConfiguration create() {
        ArrayList<OutboundRedirectConfiguration> redirectConfigurations = new ArrayList<OutboundRedirectConfiguration>();
        for (OutboundRedirectConfigurationBuilder builder : this.redirects) {
            redirectConfigurations.add(builder.create());
        }
        PathConfiguration pathConfiguration = new PathConfiguration(this.groupName, this.uri, this.secured, this.methods, redirectConfigurations);
        AuthenticationConfiguration authenticationConfiguration = null;
        if (this.authenticationConfigBuilder != null) {
            authenticationConfiguration = this.authenticationConfigBuilder.create(pathConfiguration);
        }
        AuthorizationConfiguration authorizationConfiguration = null;
        if (this.authorizationConfigurationBuilder != null) {
            authorizationConfiguration = this.authorizationConfigurationBuilder.create(pathConfiguration);
        }
        InboundHeaderConfiguration inboundHeaderConfiguration = null;
        if (this.inboundHeaderConfigurationBuilder != null) {
            inboundHeaderConfiguration = this.inboundHeaderConfigurationBuilder.create(pathConfiguration);
        }
        LogoutConfiguration logoutConfiguration = null;
        if (this.logoutConfigurationBuilder != null) {
            logoutConfiguration = this.logoutConfigurationBuilder.create(pathConfiguration);
        }
        pathConfiguration.setAuthenticationConfiguration(authenticationConfiguration);
        pathConfiguration.setAuthorizationConfiguration(authorizationConfiguration);
        pathConfiguration.setInboundHeaderConfiguration(inboundHeaderConfiguration);
        pathConfiguration.setLogoutConfiguration(logoutConfiguration);
        return pathConfiguration;
    }
}

