/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPConnectionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ExtCapability;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.ProtonHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.VersionLoader;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transaction.Coordinator;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.apache.qpid.proton.engine.Transport;
import org.jboss.logging.Logger;

public class AMQPConnectionContext
extends ProtonInitializable {
    private static final Logger log = Logger.getLogger(AMQPConnectionContext.class);
    public static final Symbol CONNECTION_OPEN_FAILED = Symbol.valueOf((String)"amqp:connection-establishment-failed");
    public static final String AMQP_CONTAINER_ID = "amqp-container-id";
    protected final ProtonHandler handler;
    protected AMQPConnectionCallback connectionCallback;
    private final String containerId;
    private final Map<Symbol, Object> connectionProperties = new HashMap<Symbol, Object>();
    private final ScheduledExecutorService scheduledPool;
    private final Map<Session, AMQPSessionContext> sessions = new ConcurrentHashMap<Session, AMQPSessionContext>();
    protected LocalListener listener = new LocalListener();

    public AMQPConnectionContext(AMQPConnectionCallback connectionSP, String containerId, int idleTimeout, int maxFrameSize, int channelMax, Executor dispatchExecutor, ScheduledExecutorService scheduledPool) {
        this.connectionCallback = connectionSP;
        this.containerId = containerId != null ? containerId : UUID.randomUUID().toString();
        this.connectionProperties.put(AmqpSupport.PRODUCT, "apache-activemq-artemis");
        this.connectionProperties.put(AmqpSupport.VERSION, VersionLoader.getVersion().getFullVersion());
        this.scheduledPool = scheduledPool;
        this.connectionCallback.setConnection(this);
        this.handler = new ProtonHandler(dispatchExecutor);
        Transport transport = this.handler.getTransport();
        transport.setEmitFlowEventOnSend(false);
        if (idleTimeout > 0) {
            transport.setIdleTimeout(idleTimeout);
        }
        transport.setChannelMax(channelMax);
        transport.setMaxFrameSize(maxFrameSize);
        this.handler.addEventHandler(this.listener);
    }

    protected AMQPSessionContext newSessionExtension(Session realSession) throws ActiveMQAMQPException {
        AMQPSessionCallback sessionSPI = this.connectionCallback.createSessionCallback(this);
        AMQPSessionContext protonSession = new AMQPSessionContext(sessionSPI, this, realSession);
        return protonSession;
    }

    public SASLResult getSASLResult() {
        return this.handler.getSASLResult();
    }

    public void inputBuffer(ByteBuf buffer) {
        if (log.isTraceEnabled()) {
            ByteUtil.debugFrame((Logger)log, (String)"Buffer Received ", (ByteBuf)buffer);
        }
        this.handler.inputBuffer(buffer);
    }

    public void destroy() {
        this.connectionCallback.close();
    }

    public boolean isSyncOnFlush() {
        return false;
    }

    public Object getLock() {
        return this.handler.getLock();
    }

    public int capacity() {
        return this.handler.capacity();
    }

    public void outputDone(int bytes) {
        this.handler.outputDone(bytes);
    }

    public void flush() {
        this.handler.flush();
    }

    public void close(ErrorCondition errorCondition) {
        this.handler.close(errorCondition);
    }

    protected AMQPSessionContext getSessionExtension(Session realSession) throws ActiveMQAMQPException {
        AMQPSessionContext sessionExtension = this.sessions.get(realSession);
        if (sessionExtension == null) {
            sessionExtension = this.newSessionExtension(realSession);
            realSession.setContext((Object)sessionExtension);
            this.sessions.put(realSession, sessionExtension);
        }
        return sessionExtension;
    }

    protected boolean validateConnection(Connection connection) {
        return this.connectionCallback.validateConnection(connection, this.handler.getSASLResult());
    }

    public boolean checkDataReceived() {
        return this.handler.checkDataReceived();
    }

    public long getCreationTime() {
        return this.handler.getCreationTime();
    }

    protected void flushBytes() {
        ByteBuf bytes;
        while ((bytes = this.handler.outputBuffer()) != null) {
            this.connectionCallback.onTransport(bytes, this);
        }
    }

    public String getRemoteContainer() {
        return this.handler.getConnection().getRemoteContainer();
    }

    public String getPubSubPrefix() {
        return null;
    }

    protected void initInternal() throws Exception {
    }

    protected void remoteLinkOpened(Link link) throws Exception {
        AMQPSessionContext protonSession = this.getSessionExtension(link.getSession());
        link.setSource(link.getRemoteSource());
        link.setTarget(link.getRemoteTarget());
        if (link instanceof Receiver) {
            Receiver receiver = (Receiver)link;
            if (link.getRemoteTarget() instanceof Coordinator) {
                Coordinator coordinator = (Coordinator)link.getRemoteTarget();
                protonSession.addTransactionHandler(coordinator, receiver);
            } else {
                protonSession.addReceiver(receiver);
            }
        } else {
            Sender sender = (Sender)link;
            protonSession.addSender(sender);
            sender.offer(1);
        }
    }

    public Symbol[] getConnectionCapabilitiesOffered() {
        return ExtCapability.getCapabilities();
    }

    public void open(Map<Symbol, Object> connectionProperties) {
        this.handler.open(this.containerId, connectionProperties);
    }

    public String getContainer() {
        return this.containerId;
    }

    public void addEventHandler(EventHandler eventHandler) {
        this.handler.addEventHandler(eventHandler);
    }

    class LocalListener
    implements EventHandler {
        LocalListener() {
        }

        @Override
        public void onInit(Connection connection) throws Exception {
        }

        @Override
        public void onLocalOpen(Connection connection) throws Exception {
        }

        @Override
        public void onLocalClose(Connection connection) throws Exception {
        }

        @Override
        public void onFinal(Connection connection) throws Exception {
        }

        @Override
        public void onInit(Session session) throws Exception {
        }

        @Override
        public void onFinal(Session session) throws Exception {
        }

        @Override
        public void onInit(Link link) throws Exception {
        }

        @Override
        public void onLocalOpen(Link link) throws Exception {
        }

        @Override
        public void onLocalClose(Link link) throws Exception {
        }

        @Override
        public void onFinal(Link link) throws Exception {
        }

        @Override
        public void onAuthInit(ProtonHandler handler, Connection connection, boolean sasl) {
            if (sasl) {
                handler.createServerSASL(AMQPConnectionContext.this.connectionCallback.getSASLMechnisms());
            } else if (!AMQPConnectionContext.this.connectionCallback.isSupportsAnonymous()) {
                AMQPConnectionContext.this.connectionCallback.sendSASLSupported();
                AMQPConnectionContext.this.connectionCallback.close();
                handler.close(null);
            }
        }

        @Override
        public void onTransport(Transport transport) {
            AMQPConnectionContext.this.flushBytes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteOpen(Connection connection) throws Exception {
            Object object = AMQPConnectionContext.this.getLock();
            synchronized (object) {
                try {
                    AMQPConnectionContext.this.initInternal();
                }
                catch (Exception e) {
                    log.error((Object)"Error init connection", (Throwable)e);
                }
                if (!AMQPConnectionContext.this.validateConnection(connection)) {
                    connection.close();
                } else {
                    connection.setContext((Object)AMQPConnectionContext.this);
                    connection.setContainer(AMQPConnectionContext.this.containerId);
                    connection.setProperties(AMQPConnectionContext.this.connectionProperties);
                    connection.setOfferedCapabilities(AMQPConnectionContext.this.getConnectionCapabilitiesOffered());
                    connection.open();
                }
            }
            AMQPConnectionContext.this.initialise();
            if (connection.getRemoteProperties() == null || !connection.getRemoteProperties().containsKey(CONNECTION_OPEN_FAILED)) {
                long nextKeepAliveTime = AMQPConnectionContext.this.handler.tick(true);
                AMQPConnectionContext.this.flushBytes();
                if (nextKeepAliveTime > 0L && AMQPConnectionContext.this.scheduledPool != null) {
                    AMQPConnectionContext.this.scheduledPool.schedule(new Runnable(){

                        @Override
                        public void run() {
                            long rescheduleAt = AMQPConnectionContext.this.handler.tick(false) - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                            AMQPConnectionContext.this.flushBytes();
                            if (rescheduleAt > 0L) {
                                AMQPConnectionContext.this.scheduledPool.schedule(this, rescheduleAt, TimeUnit.MILLISECONDS);
                            }
                        }
                    }, nextKeepAliveTime - TimeUnit.NANOSECONDS.toMillis(System.nanoTime()), TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteClose(Connection connection) {
            Object object = AMQPConnectionContext.this.getLock();
            synchronized (object) {
                connection.close();
                connection.free();
                for (AMQPSessionContext protonSession : AMQPConnectionContext.this.sessions.values()) {
                    protonSession.close();
                }
                AMQPConnectionContext.this.sessions.clear();
            }
            this.onTransport(AMQPConnectionContext.this.handler.getTransport());
            AMQPConnectionContext.this.destroy();
        }

        @Override
        public void onLocalOpen(Session session) throws Exception {
            AMQPConnectionContext.this.getSessionExtension(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteOpen(Session session) throws Exception {
            AMQPConnectionContext.this.getSessionExtension(session).initialise();
            Object object = AMQPConnectionContext.this.getLock();
            synchronized (object) {
                session.open();
            }
        }

        @Override
        public void onLocalClose(Session session) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoteClose(Session session) throws Exception {
            Object object = AMQPConnectionContext.this.getLock();
            synchronized (object) {
                session.close();
                session.free();
            }
            AMQPSessionContext sessionContext = (AMQPSessionContext)session.getContext();
            if (sessionContext != null) {
                sessionContext.close();
                AMQPConnectionContext.this.sessions.remove(session);
                session.setContext(null);
            }
        }

        @Override
        public void onRemoteOpen(Link link) throws Exception {
            AMQPConnectionContext.this.remoteLinkOpened(link);
        }

        @Override
        public void onFlow(Link link) throws Exception {
            if (link.getContext() != null) {
                ((ProtonDeliveryHandler)link.getContext()).onFlow(link.getCredit(), link.getDrain());
            }
        }

        @Override
        public void onRemoteClose(Link link) throws Exception {
            link.close();
            link.free();
            ProtonDeliveryHandler linkContext = (ProtonDeliveryHandler)link.getContext();
            if (linkContext != null) {
                linkContext.close(true);
            }
        }

        @Override
        public void onRemoteDetach(Link link) throws Exception {
            link.detach();
            link.free();
        }

        @Override
        public void onLocalDetach(Link link) throws Exception {
            Object context = link.getContext();
            if (context instanceof ProtonServerSenderContext) {
                ProtonServerSenderContext senderContext = (ProtonServerSenderContext)context;
                senderContext.close(false);
            }
        }

        @Override
        public void onDelivery(Delivery delivery) throws Exception {
            ProtonDeliveryHandler handler = (ProtonDeliveryHandler)delivery.getLink().getContext();
            if (handler != null) {
                handler.onMessage(delivery);
            } else {
                System.err.println("Handler is null, can't delivery " + delivery);
            }
        }
    }
}

