/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.authz;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.util.EnumerationIterator;

final class OneRole
implements Roles {
    private final String role;

    OneRole(String role) {
        this.role = role;
    }

    @Override
    public boolean contains(String roleName) {
        return this.role.equals(roleName);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Spliterator<String> spliterator() {
        return Spliterators.spliterator(this.iterator(), 1L, 321);
    }

    @Override
    public Roles and(Roles other) {
        return other.contains(this.role) ? this : NONE;
    }

    @Override
    public Roles or(Roles other) {
        return other.contains(this.role) ? other : Roles.super.or(other);
    }

    @Override
    public Roles minus(Roles other) {
        return other.contains(this.role) ? NONE : this;
    }

    @Override
    public Roles addSuffix(String suffix) {
        return new OneRole(this.role + suffix);
    }

    @Override
    public Roles addPrefix(String prefix) {
        return new OneRole(prefix + this.role);
    }

    @Override
    public Iterator<String> iterator() {
        return EnumerationIterator.over(this.role);
    }
}

