/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.probe;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.Prioritized;
import org.jboss.weld.event.CurrentEventMetadata;
import org.jboss.weld.event.ObserverNotifier;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.probe.EventInfo;
import org.jboss.weld.probe.Probe;
import org.jboss.weld.probe.ProbeExtension;
import org.jboss.weld.probe.ProbeLogger;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.reflection.Formats;

@Vetoed
class ProbeObserver
implements ObserverMethod<Object>,
Prioritized {
    private static final int PRIORITY_OFFSET = 100;
    private final Pattern excludePattern;
    private final Probe probe;
    private final CurrentEventMetadata currentEventMetadata;
    private final BeanManagerImpl manager;

    ProbeObserver(BeanManagerImpl manager, Pattern excludePattern, Probe probe) {
        this.currentEventMetadata = (CurrentEventMetadata)manager.getServices().get(CurrentEventMetadata.class);
        this.manager = manager;
        this.excludePattern = excludePattern;
        this.probe = probe;
    }

    public Class<?> getBeanClass() {
        return ProbeExtension.class;
    }

    public Type getObservedType() {
        return Object.class;
    }

    public Set<Annotation> getObservedQualifiers() {
        return Collections.emptySet();
    }

    public Reception getReception() {
        return Reception.ALWAYS;
    }

    public TransactionPhase getTransactionPhase() {
        return TransactionPhase.IN_PROGRESS;
    }

    public void notify(Object event) {
        EventMetadata metadata = (EventMetadata)this.currentEventMetadata.peek();
        if (this.excludePattern != null && this.excludePattern.matcher(Formats.formatType((Type)metadata.getType(), (boolean)false)).matches()) {
            ProbeLogger.LOG.eventExcluded(metadata.getType());
            return;
        }
        boolean containerEvent = this.isContainerEvent(metadata.getQualifiers());
        List<ObserverMethod<?>> observers = this.resolveObservers(metadata, containerEvent);
        EventInfo info = new EventInfo(metadata.getType(), metadata.getQualifiers(), event, metadata.getInjectionPoint(), observers, containerEvent, System.currentTimeMillis());
        this.probe.addEvent(info);
    }

    private List<ObserverMethod<?>> resolveObservers(EventMetadata metadata, boolean containerEvent) {
        ArrayList<ObserverMethod> observers = new ArrayList<ObserverMethod>();
        ObserverNotifier notifier = containerEvent ? this.manager.getAccessibleLenientObserverNotifier() : this.manager.getGlobalLenientObserverNotifier();
        ResolvedObservers resolvedObservers = notifier.resolveObserverMethods(metadata.getType(), metadata.getQualifiers());
        for (ObserverMethod observer : resolvedObservers.getAllObservers()) {
            if (this.getBeanClass() == observer.getBeanClass()) continue;
            observers.add(observer);
        }
        return ImmutableList.copyOf(observers);
    }

    public int getPriority() {
        return 100;
    }

    private boolean isContainerEvent(Set<Annotation> qualifiers) {
        for (Annotation annotation : qualifiers) {
            if (annotation.annotationType() != Initialized.class && annotation.annotationType() != Destroyed.class) continue;
            return true;
        }
        return false;
    }
}

