/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyManager;
import org.jboss.as.cli.impl.aesh.cmd.security.model.KeyStore;
import org.jboss.as.cli.impl.aesh.cmd.security.model.ServerSSLContext;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public abstract class ElytronUtil {
    public static final String JKS = "JKS";
    public static final String PKCS12 = "PKCS12";
    public static final String TLS_V1_2 = "TLSv1.2";

    private ElytronUtil() {
    }

    static String retrieveKeyStorePassword(CommandContext ctx, String name) throws OperationFormatException, IOException {
        ModelNode res;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-attribute");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        builder.addProperty("name", "credential-reference");
        ModelNode request = builder.buildRequest();
        ModelNode response = ctx.getModelControllerClient().execute(request);
        String password = null;
        if (Util.isSuccess(response) && response.hasDefined("result") && (res = response.get("result")).hasDefined("clear-text")) {
            password = res.get("clear-text").asString();
        }
        return password;
    }

    static String findMatchingKeyStore(CommandContext ctx, File path, String relativeTo, String password, String type, Boolean required, String alias) throws OperationFormatException, IOException {
        ModelNode resource = ElytronUtil.buildKeyStoreResource(path, relativeTo, password, type, required, alias);
        List<String> names = ElytronUtil.findMatchingResources(ctx, "key-store", resource);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    static List<String> findMatchingKeyStores(CommandContext ctx, File path, String relativeTo) throws OperationFormatException, IOException {
        ModelNode resource = ElytronUtil.buildKeyStoreResource(path, relativeTo, null, null, null, null);
        return ElytronUtil.findMatchingResources(ctx, "key-store", resource);
    }

    private static ModelNode buildKeyStoreResource(File path, String relativeTo, String password, String type, Boolean required, String alias) throws IOException {
        ModelNode localKS = new ModelNode();
        if (path != null) {
            localKS.get("path").set(path.getPath());
        }
        if (relativeTo != null) {
            localKS.get("relative-to").set(relativeTo);
        } else {
            localKS.get("relative-to");
        }
        if (password != null) {
            localKS.get("credential-reference").set(ElytronUtil.buildCredentialReferences(password));
        }
        if (type != null) {
            localKS.get("type").set(type);
        }
        if (required != null) {
            localKS.get("required").set(required.booleanValue());
        }
        if (alias != null) {
            localKS.get(new String[]{"alias-filter", alias});
        } else {
            localKS.get("alias-filter");
        }
        return localKS;
    }

    private static ModelNode buildKeyManagerResource(KeyStore keyStore, String alias, String algorithm) {
        ModelNode localKM = new ModelNode();
        if (keyStore.getPassword() != null) {
            localKM.get("credential-reference").set(ElytronUtil.buildCredentialReferences(keyStore.getPassword()));
        }
        localKM.get("key-store").set(keyStore.getName());
        if (alias != null) {
            localKM.get(new String[]{"alias-filter", alias});
        } else {
            localKM.get("alias-filter");
        }
        if (algorithm != null) {
            localKM.get(new String[]{"algorithm", algorithm});
        } else {
            localKM.get("algorithm");
        }
        return localKM;
    }

    private static ModelNode buildTrustManagerResource(KeyStore keyStore, String alias, String algorithm) {
        ModelNode mn = ElytronUtil.buildKeyManagerResource(keyStore, alias, algorithm);
        mn.remove("credential-reference");
        return mn;
    }

    private static List<String> findMatchingResources(CommandContext ctx, String type, ModelNode resource) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-children-resources");
        builder.addNode("subsystem", "elytron");
        builder.addProperty("child-type", type);
        ModelNode request = builder.buildRequest();
        ModelNode response = ctx.getModelControllerClient().execute(request);
        ArrayList<String> matches = new ArrayList<String>();
        if (Util.isSuccess(response) && response.hasDefined("result")) {
            ModelNode res = response.get("result");
            for (String ksName : res.keys()) {
                ModelNode ks = res.get(ksName);
                ArrayList<String> meaninglessKeys = new ArrayList<String>();
                for (String k : ks.keys()) {
                    if (resource.keys().contains(k)) continue;
                    meaninglessKeys.add(k);
                }
                for (String s : meaninglessKeys) {
                    ks.remove(s);
                }
                if (!resource.equals(ks)) continue;
                matches.add(ksName);
            }
        }
        return matches;
    }

    static String findMatchingKeyManager(CommandContext ctx, KeyStore keyStore, String alias, String algorithm) throws OperationFormatException, IOException {
        ModelNode resource = ElytronUtil.buildKeyManagerResource(keyStore, alias, algorithm);
        List<String> names = ElytronUtil.findMatchingResources(ctx, "key-manager", resource);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    static String findMatchingTrustManager(CommandContext ctx, KeyStore keyStore, String alias, String algorithm) throws OperationFormatException, IOException {
        ModelNode resource = ElytronUtil.buildTrustManagerResource(keyStore, alias, algorithm);
        List<String> names = ElytronUtil.findMatchingResources(ctx, "trust-manager", resource);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    static String findMatchingSSLContext(CommandContext ctx, ServerSSLContext sslCtx) throws OperationFormatException, IOException {
        List<String> names = ElytronUtil.findMatchingResources(ctx, "server-ssl-context", sslCtx.buildResource());
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0);
    }

    static ModelNode addKeyStore(CommandContext ctx, String name, File path, String relativeTo, String password, String type, Boolean required, String alias) throws Exception {
        ModelNode mn = ElytronUtil.buildKeyStoreResource(path, relativeTo, password, type, required, alias);
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        return builder.buildRequest();
    }

    static ModelNode generateKeyPair(CommandContext ctx, String name, String dn, String alias, Long validity, String keyAlg, int keySize) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("generate-key-pair");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        builder.getModelNode().get("distinguished-name").set(dn);
        builder.getModelNode().get("algorithm").set(keyAlg);
        builder.getModelNode().get("key-size").set(keySize);
        builder.getModelNode().get("alias").set(alias);
        if (validity != null) {
            builder.getModelNode().get("validity").set(validity.longValue());
        }
        return builder.buildRequest();
    }

    static ModelNode importCertificate(CommandContext ctx, File trustedCertificate, String alias, boolean validate, KeyStore trustStore, boolean trust) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("import-certificate");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", trustStore.getName());
        builder.getModelNode().get("alias").set(alias);
        builder.getModelNode().get("path").set(trustedCertificate.getAbsolutePath());
        builder.getModelNode().get("trust-cacerts").set(trust);
        builder.getModelNode().get("validate").set(validate);
        return builder.buildRequest();
    }

    static ModelNode storeKeyStore(CommandContext ctx, String name) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("store");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        return builder.buildRequest();
    }

    static ModelNode removeKeyStore(CommandContext ctx, String name) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("remove");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        return builder.buildRequest();
    }

    static ModelNode exportCertificate(CommandContext ctx, String name, File path, String relativeTo, String alias, boolean pem) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("export-certificate");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        builder.getModelNode().get("path").set(path.getPath());
        builder.getModelNode().get("alias").set(alias);
        if (relativeTo != null) {
            builder.getModelNode().get("relative-to").set(relativeTo);
        }
        builder.getModelNode().get("pem").set(pem);
        return builder.buildRequest();
    }

    static ModelNode generateSigningRequest(CommandContext ctx, String name, File path, String relativeTo, String alias) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("generate-certificate-signing-request");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        builder.getModelNode().get("path").set(path.getPath());
        builder.getModelNode().get("alias").set(alias);
        if (relativeTo != null) {
            builder.getModelNode().get("relative-to").set(relativeTo);
        }
        return builder.buildRequest();
    }

    static ModelNode addKeyManager(CommandContext ctx, KeyStore keyStore, String name, String alias, String algorithm) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-manager", name);
        ModelNode mn = ElytronUtil.buildKeyManagerResource(keyStore, alias, algorithm);
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        builder.getModelNode().get("credential-reference").set(ElytronUtil.buildCredentialReferences(keyStore.getPassword()));
        return builder.buildRequest();
    }

    static ModelNode addTrustManager(CommandContext ctx, KeyStore keyStore, String name, String alias, String algorithm) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("trust-manager", name);
        ModelNode mn = ElytronUtil.buildKeyManagerResource(keyStore, alias, algorithm);
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        if (keyStore.getPassword() != null) {
            builder.getModelNode().get("credential-reference").set(ElytronUtil.buildCredentialReferences(keyStore.getPassword()));
        }
        return builder.buildRequest();
    }

    static ModelNode addServerSSLContext(CommandContext ctx, ServerSSLContext sslCtx, String name) throws Exception {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("add");
        builder.addNode("subsystem", "elytron");
        builder.addNode("server-ssl-context", name);
        ModelNode mn = sslCtx.buildResource();
        for (String k : mn.keys()) {
            builder.getModelNode().get(k).set(mn.get(k));
        }
        return builder.buildRequest();
    }

    private static ModelNode buildCredentialReferences(String password) {
        ModelNode mn = new ModelNode();
        mn.get("clear-text").set(password);
        return mn;
    }

    static boolean keyManagerExists(CommandContext ctx, String name) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-manager", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static boolean trustManagerExists(CommandContext ctx, String name) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("trust-manager", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static boolean keyStoreExists(CommandContext ctx, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static boolean serverSSLContextExists(CommandContext ctx, String name) throws OperationFormatException, IOException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        builder.addNode("server-ssl-context", name);
        return Util.isSuccess(ctx.getModelControllerClient().execute(builder.buildRequest()));
    }

    public static List<String> getKeyStoreNames(ModelControllerClient client) {
        return ElytronUtil.getNames(client, "key-store");
    }

    private static List<String> getNames(ModelControllerClient client, String type) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-children-names");
            builder.addNode("subsystem", "elytron");
            builder.addProperty("child-type", type);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (Util.isSuccess(outcome)) {
                return Util.getList(outcome);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private static ModelNode getChildResource(String name, String type, CommandContext ctx) {
        ModelNode request;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        try {
            builder.setOperationName("read-resource");
            builder.addNode("subsystem", "elytron");
            builder.addNode(type, name);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e) {
            throw new IllegalStateException("Failed to build operation", e);
        }
        try {
            ModelNode outcome = ctx.getModelControllerClient().execute(request);
            if (Util.isSuccess(outcome)) {
                return outcome.get("result");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ServerSSLContext getServerSSLContext(CommandContext context, String sslContextName) {
        ModelNode sslContext = ElytronUtil.getChildResource(sslContextName, "server-ssl-context", context);
        ServerSSLContext ctx = null;
        if (sslContext != null) {
            String kmName = sslContext.get("key-manager").asString();
            ModelNode km = ElytronUtil.getChildResource(kmName, "key-manager", context);
            String ksName = km.get("key-store").asString();
            KeyStore keyStore = new KeyStore(ksName, null, true);
            KeyManager keyManager = new KeyManager(kmName, keyStore, true);
            KeyManager trustManager = null;
            if (sslContext.hasDefined("trust-manager")) {
                trustManager = new KeyManager(sslContext.get("trust-manager").asString(), keyStore, true);
            }
            ctx = new ServerSSLContext(ksName, keyManager, trustManager, true);
        }
        return ctx;
    }

    public static KeyStore getKeyStore(CommandContext ctx, String name) throws OperationFormatException, IOException {
        String password = ElytronUtil.retrieveKeyStorePassword(ctx, name);
        if (password == null) {
            // empty if block
        }
        return new KeyStore(name, password, true);
    }

    public static boolean isElytronSupported(CommandContext commandContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-resource");
        builder.addNode("subsystem", "elytron");
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        return Util.isSuccess(response);
    }

    public static boolean isKeyStoreManagementSupported(CommandContext commandContext) throws IOException, OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("read-operation-description");
        builder.addNode("subsystem", "elytron");
        builder.addNode("key-store", "?");
        builder.addProperty("name", "generate-key-pair");
        ModelNode response = commandContext.getModelControllerClient().execute(builder.buildRequest());
        return Util.isSuccess(response);
    }
}

