/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.rm;

import java.util.List;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.aesh.readline.terminal.Key;

@CommandDefinition(name="rm", description="remove files or directories.")
public class Rm
implements Command<CommandInvocation> {
    @Option(shortName=104, name="help", hasValue=false, description="display this help and exit")
    private boolean help;
    @Option(shortName=100, name="dir", hasValue=false, description="remove empty directories")
    private boolean dir;
    @Option(shortName=105, name="interactive", hasValue=false, description="prompt before every removal")
    private boolean interactive;
    @Option(shortName=118, name="verbose", hasValue=false, description="explain what is being done")
    private boolean verbose;
    @Arguments
    private List<Resource> args;

    @Override
    public CommandResult execute(CommandInvocation ci) throws InterruptedException {
        if (this.help || this.args == null || this.args.isEmpty()) {
            ci.getShell().writeln(ci.getHelpInfo("rm"));
            return CommandResult.SUCCESS;
        }
        Resource currentDir = ci.getAeshContext().getCurrentWorkingDirectory();
        for (Resource r : this.args) {
            Resource res = r.resolve(currentDir).get(0);
            if (this.dir) {
                this.rmDir(res, ci);
                continue;
            }
            this.rmFile(res, ci);
        }
        return CommandResult.SUCCESS;
    }

    private void rmFile(Resource r, CommandInvocation ci) throws InterruptedException {
        if (r.exists()) {
            if (r.isLeaf()) {
                if (this.interactive) {
                    ci.getShell().writeln("remove regular file '" + r.getName() + "' ? (y/n)");
                    if (Key.y.equalTo(ci.input())) {
                        r.delete();
                    }
                } else {
                    r.delete();
                }
                if (this.verbose) {
                    ci.getShell().writeln("removed '" + r.getName() + "'");
                }
            } else if (r.isDirectory()) {
                ci.getShell().writeln("cannot remove '" + r.getName() + "': Is a directory");
            }
        }
    }

    private void rmDir(Resource r, CommandInvocation ci) throws InterruptedException {
        if (r.exists() && r.isDirectory()) {
            if (this.interactive) {
                ci.getShell().writeln("remove directory '" + r.getName() + "' ? (y/n)");
                if (Key.y.equalTo(ci.input())) {
                    r.delete();
                }
            } else {
                r.delete();
            }
            if (this.verbose) {
                ci.getShell().writeln("removed directory: '" + r.getName() + "'");
            }
        }
    }
}

