/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.infinispan.subsystem.BackupOperationContext;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum BackupOperation implements Operation<BackupOperationContext>
{
    BRING_SITE_ONLINE("bring-site-online", false){

        public ModelNode execute(BackupOperationContext context) {
            return new ModelNode(context.getOperations().bringSiteOnline(context.getSite()));
        }
    }
    ,
    TAKE_SITE_OFFLINE("take-site-offline", false){

        public ModelNode execute(BackupOperationContext context) {
            return new ModelNode(context.getOperations().takeSiteOffline(context.getSite()));
        }
    }
    ,
    SITE_STATUS("site-status", true){

        public ModelNode execute(BackupOperationContext context) {
            return new ModelNode(context.getOperations().siteStatus(context.getSite()));
        }
    };

    private final OperationDefinition definition;

    private BackupOperation(String name, boolean readOnly) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(name, InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{BackupResourceDefinition.WILDCARD_PATH}));
        if (readOnly) {
            builder.setReadOnly();
        }
        this.definition = builder.setReplyType(ModelType.STRING).setRuntimeOnly().build();
    }

    public OperationDefinition getDefinition() {
        return this.definition;
    }
}

