/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanSubsystemResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.spi.GroupAliasBuilderProvider;
import org.wildfly.clustering.spi.GroupBuilderProvider;
import org.wildfly.clustering.spi.LocalGroupBuilderProvider;

public class InfinispanSubsystemServiceHandler
implements ResourceServiceHandler {
    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        InfinispanLogger.ROOT_LOGGER.activatingSubsystem();
        PathAddress address = context.getCurrentAddress();
        ServiceTarget target = context.getServiceTarget();
        for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(LocalGroupBuilderProvider.class, LocalGroupBuilderProvider.class.getClassLoader())) {
            InfinispanLogger.ROOT_LOGGER.debugf("Installing %s for %s group", groupBuilderProvider.getClass().getSimpleName(), "local");
            for (CapabilityServiceBuilder builder : groupBuilderProvider.getBuilders(requirement -> InfinispanSubsystemResourceDefinition.LOCAL_CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), "local")) {
                builder.configure(context).build(target).install();
            }
        }
        if (!context.hasOptionalCapability(JGroupsRequirement.CHANNEL.getDefaultRequirement().getName(), null, null)) {
            for (GroupAliasBuilderProvider groupAliasBuilderProvider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
                for (CapabilityServiceBuilder builder : groupAliasBuilderProvider.getBuilders(requirement -> InfinispanSubsystemResourceDefinition.CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), null, "local")) {
                    builder.configure(context).build(target).install();
                }
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(LocalGroupBuilderProvider.class, LocalGroupBuilderProvider.class.getClassLoader())) {
            for (ServiceNameProvider builder : groupBuilderProvider.getBuilders(requirement -> InfinispanSubsystemResourceDefinition.LOCAL_CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), "local")) {
                context.removeService(builder.getServiceName());
            }
        }
        if (!context.hasOptionalCapability(JGroupsRequirement.CHANNEL.getDefaultRequirement().getName(), null, null)) {
            for (GroupAliasBuilderProvider groupAliasBuilderProvider : ServiceLoader.load(GroupAliasBuilderProvider.class, GroupAliasBuilderProvider.class.getClassLoader())) {
                for (ServiceNameProvider builder : groupAliasBuilderProvider.getBuilders(requirement -> InfinispanSubsystemResourceDefinition.CLUSTERING_CAPABILITIES.get(requirement).getServiceName(address), null, "local")) {
                    context.removeService(builder.getServiceName());
                }
            }
        }
    }
}

