/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.stream.Stream;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationBuilder;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class LocalCacheBuilder
extends CacheConfigurationBuilder {
    private final ValueDependency<MemoryConfiguration> memory;
    private final ValueDependency<PersistenceConfiguration> persistence;
    private final ValueDependency<TransactionConfiguration> transaction;

    LocalCacheBuilder(PathAddress address) {
        super(address);
        this.memory = new InjectedValueDependency(CacheComponent.MEMORY.getServiceName(address), MemoryConfiguration.class);
        this.persistence = new InjectedValueDependency(CacheComponent.PERSISTENCE.getServiceName(address), PersistenceConfiguration.class);
        this.transaction = new InjectedValueDependency(CacheComponent.TRANSACTION.getServiceName(address), TransactionConfiguration.class);
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        ServiceBuilder<Configuration> builder = super.build(target);
        Stream.of(this.memory, this.persistence, this.transaction).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        MemoryConfiguration memory = (MemoryConfiguration)this.memory.getValue();
        PersistenceConfiguration persistence = (PersistenceConfiguration)this.persistence.getValue();
        TransactionConfiguration transaction = (TransactionConfiguration)this.transaction.getValue();
        builder.simpleCache(memory.storageType() == StorageType.OBJECT && !transaction.transactionMode().isTransactional() && !persistence.usingStores());
    }
}

