/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.infinispan.configuration.cache.StorageType;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.MetricExecutor;
import org.jboss.as.clustering.controller.MetricHandler;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistration;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.EvictionMetric;
import org.jboss.as.clustering.infinispan.subsystem.EvictionMetricExecutor;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.MemoryBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class MemoryResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration> {
    static final PathElement WILDCARD_PATH = MemoryResourceDefinition.pathElement("*");
    private final StorageType type;
    private final Consumer<ResourceDescriptor> descriptorConfigurator;

    static PathElement pathElement(String value) {
        return PathElement.pathElement((String)"memory", (String)value);
    }

    MemoryResourceDefinition(StorageType type, PathElement path, Consumer<ResourceDescriptor> descriptorConfigurator) {
        super(path, InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path, WILDCARD_PATH}));
        this.type = type;
        this.descriptorConfigurator = descriptorConfigurator;
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(Attribute.class);
        this.descriptorConfigurator.accept(descriptor);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler(address -> new MemoryBuilder(this.type, address));
        new SimpleResourceRegistration(descriptor, (ResourceServiceHandler)handler).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        if (registration.isRuntimeOnlyRegistrationValid()) {
            new MetricHandler((MetricExecutor)new EvictionMetricExecutor(), EvictionMetric.class).register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        SIZE("size", ModelType.LONG, new ModelNode(-1L), UnaryOperator.identity());

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue, UnaryOperator<SimpleAttributeDefinitionBuilder> configurator) {
            this.definition = ((SimpleAttributeDefinitionBuilder)configurator.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

