/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.concurrent.ClassLoaderThreadFactory;

public class ThreadPoolBuilder
extends GlobalComponentBuilder<ThreadPoolConfiguration> {
    private final ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(null);
    private final ThreadPoolDefinition definition;

    ThreadPoolBuilder(ThreadPoolDefinition definition, PathAddress address) {
        super(definition, address);
        this.definition = definition;
    }

    public Builder<ThreadPoolConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        BlockingThreadPoolExecutorFactory factory = new BlockingThreadPoolExecutorFactory(this.definition.getMaxThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt(), this.definition.getMinThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt(), this.definition.getQueueLength().resolveModelAttribute((ExpressionResolver)context, model).asInt(), this.definition.getKeepAliveTime().resolveModelAttribute((ExpressionResolver)context, model).asLong()){

            public ExecutorService createExecutor(ThreadFactory factory) {
                return super.createExecutor((ThreadFactory)new ClassLoaderThreadFactory(factory, AccessController.doPrivileged(() -> ClassLoaderThreadFactory.class.getClassLoader())));
            }
        };
        this.builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        return this;
    }

    public ThreadPoolConfiguration getValue() {
        return this.builder.create();
    }
}

